/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.publish;

import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicWebPublishOperation;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.compiler.CompilationException;
import oracle.eclipse.tools.webservices.compiler.InvalidWebServiceException;
import oracle.eclipse.tools.webservices.compiler.WebServiceEarProjectCompiler;
import oracle.eclipse.tools.webservices.compiler.WebServiceProjectCompiler;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class WebServiceProjectPublishTask
extends PublishTaskDelegate {
    public static final int SPLITSOURCE_OPERATION_ORDER_NO = 4;
    public static final int BUILD_OPERATION_ORDER_NO = 6;
    public static final int COPY_OPERATION_ORDER_NO = 25;

    public PublishOperation[] getTasks(IServer server, List modules) {
        if (modules == null || modules.isEmpty()) {
            return new PublishOperation[0];
        }
        IWeblogicServer ws = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (ws == null || ws.isRemote()) {
            return new PublishOperation[0];
        }
        return new PublishOperation[]{new WebServicesBuildOperation(server), new WebServicesSplitSourceOperation(server), new WebServicesCopyPublishOperation(server)};
    }

    public PublishOperation[] getTasks(IServer server, int kind, List allModulesGroups, List kindList) {
        return this.getTasks(server, allModulesGroups);
    }

    private static CoreException newBuildError(Exception e, String moduleName) {
        IStatus status = WebServicesCorePlugin.createStatus(Messages.bind((String)Messages.publish_task_error_build, (Object)moduleName), e);
        return new CoreException(status);
    }

    private static abstract class WebServicePublishOperation
    extends WeblogicWebPublishOperation {
        public WebServicePublishOperation(String taskName, String taskDescription, IServer server) {
            super(taskName, taskDescription, server);
        }

        protected boolean shouldRun(IModule earModule, IModule webModule) throws CoreException {
            IProject earProject;
            IProject webProject = webModule.getProject();
            if (!WebServiceProject.isWebServiceProject(webProject)) {
                return false;
            }
            if (earModule != null && !WlsEarFacet.isInstalled((IProject)(earProject = earModule.getProject()))) {
                String msg = Messages.bind((String)Messages.publish_task_error_missing_facet, (Object[])new Object[]{earModule.getName(), WlsEarFacet.FACET.getLabel()});
                IStatus status = WebServicesCorePlugin.createStatus(msg, null);
                throw new CoreException(status);
            }
            return true;
        }

        protected void processWebModule(IWeblogicModule weblogicEarModule, IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
            this.processWebServices(earModule, webModule, monitor);
        }

        protected abstract void processWebServices(IModule var1, IModule var2, IProgressMonitor var3) throws CoreException;

        protected IPath getGeneratedWebRoot(IModule webModule) {
            WebServiceProject wsProject = new WebServiceProject(webModule.getProject());
            return wsProject.getOutputWebRootFolder();
        }
    }

    private static class WebServicesBuildOperation
    extends WebServicePublishOperation {
        public WebServicesBuildOperation(IServer server) {
            super(Messages.publish_task_build_name, Messages.publish_task_build_description, server);
        }

        public int getOrder() {
            return 6;
        }

        protected boolean hasPublishableChanges(IWeblogicModule earModule, IWeblogicModule webModule) {
            return WebServicesBuildOperation.hasChanges((IWeblogicModule)webModule);
        }

        @Override
        protected void processWebServices(IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
            WSRuntime runtime = (WSRuntime)((Object)webModule.getProject().getAdapter(WSRuntime.class));
            if (runtime != null) {
                WebServiceProjectCompiler builder = runtime.getWebServiceProjectCompiler();
                WebServiceEarProjectCompiler earBuilder = null;
                if (earModule != null && earModule.getProject() != null) {
                    earBuilder = runtime.getWebServiceEarProjectCompiler(earModule.getProject());
                }
                try {
                    try {
                        if (earBuilder != null) {
                            earBuilder.build(monitor);
                        }
                        builder.build(monitor);
                    }
                    catch (InvalidWebServiceException e) {
                        DialogService.showErrorDialog((String)(String.valueOf(Messages.web_service_build_or_publish_failed) + "\n" + e.getMessage()), (Throwable)e);
                        throw WebServiceProjectPublishTask.newBuildError(e, webModule.getName());
                    }
                    catch (CompilationException e) {
                        DialogService.showErrorDialog((String)(String.valueOf(Messages.web_service_build_or_publish_failed) + "\n" + e.getMessage()), (Throwable)e);
                        throw WebServiceProjectPublishTask.newBuildError(e, webModule.getName());
                    }
                }
                finally {
                    runtime.close();
                }
            }
        }

        protected void processWebModuleEvenIfNoChanges(IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
        }
    }

    private static class WebServicesCopyPublishOperation
    extends WebServicePublishOperation {
        public WebServicesCopyPublishOperation(IServer server) {
            super(Messages.publish_task_copypublish_name, Messages.publish_task_copypublish_description, server);
        }

        public int getOrder() {
            return 25;
        }

        protected boolean hasPublishableChanges(IWeblogicModule earModule, IWeblogicModule webModule) {
            return true;
        }

        @Override
        protected void processWebServices(IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
        }

        protected void processWebModuleEvenIfNoChanges(IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
            WeblogicServerBehaviour ws;
            if (earModule == null && !(ws = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, null)).isDeployInSplitSrcMode()) {
                this.copyGeneratedWebRoot(webModule, this.getGeneratedWebRoot(webModule));
            }
        }
    }

    private static class WebServicesSplitSourceOperation
    extends WebServicePublishOperation {
        public WebServicesSplitSourceOperation(IServer server) {
            super(Messages.publish_task_splitsource_name, Messages.publish_task_splitsource_description, server);
        }

        public int getOrder() {
            return 4;
        }

        protected boolean hasPublishableChanges(IWeblogicModule earModule, IWeblogicModule webModule) {
            return true;
        }

        @Override
        protected void processWebServices(IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
        }

        protected void processWebModuleEvenIfNoChanges(IModule earModule, IModule webModule, IProgressMonitor monitor) throws CoreException {
            if (earModule != null) {
                WeblogicServerBehaviour ws = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, null);
                if (ws.isDeployInSplitSrcMode()) {
                    this.updateSplitSourceDescriptor(earModule, webModule, monitor, this.getGeneratedWebRoot(webModule));
                }
            } else {
                WeblogicServerBehaviour ws = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, null);
                if (ws.isDeployInSplitSrcMode()) {
                    this.updateAutoGeneratedSplitSourceDescriptor(webModule, monitor, this.getGeneratedWebRoot(webModule));
                    return;
                }
            }
        }
    }
}

