/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.publish;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.WebServicesException;
import oracle.eclipse.tools.webservices.compiler.InvalidWebServiceException;
import oracle.eclipse.tools.webservices.publish.WebServiceResource;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleArtifactAdapterDelegate;

public final class WebServiceModuleArtifactAdapter
extends ModuleArtifactAdapterDelegate {
    public IModuleArtifact getModuleArtifact(Object obj) {
        ICompilationUnit unit = WebServiceModuleArtifactAdapter.adaptObjectToCompilationUnit(obj);
        if (unit != null) {
            try {
                return this.createModuleArtifact(unit);
            }
            catch (RuntimeException cnfe) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)cnfe);
            }
        }
        return null;
    }

    public static ICompilationUnit adaptObjectToCompilationUnit(Object obj) {
        IJavaElement elem;
        if (!(obj instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)obj;
        IFile file = (IFile)adaptable.getAdapter(IFile.class);
        ICompilationUnit unit = null;
        if (file != null && (elem = JavaCore.create((IFile)file)) instanceof ICompilationUnit) {
            unit = (ICompilationUnit)elem;
        }
        if (unit == null) {
            unit = (ICompilationUnit)adaptable.getAdapter(ICompilationUnit.class);
        }
        if (WebServiceProject.isWebService(unit, true) || WebServiceProject.isWebServiceProvider(unit, true)) {
            return unit;
        }
        return null;
    }

    private IModuleArtifact createModuleArtifact(ICompilationUnit unit) {
        IProject project = unit.getJavaProject().getProject();
        if (!WebServiceProject.isWebServiceProject(project)) {
            return null;
        }
        WSRuntime runtime = (WSRuntime)((Object)project.getAdapter(WSRuntime.class));
        if (runtime == null) {
            return null;
        }
        String uri = null;
        try {
            try {
                uri = runtime.getServiceUri(unit);
            }
            catch (WebServicesException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webservices", (Throwable)e);
                runtime.close();
                return null;
            }
            catch (InvalidWebServiceException e) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
                runtime.close();
                return null;
            }
        }
        finally {
            runtime.close();
        }
        if (uri != null) {
            Path webPath = new Path(uri);
            IModule module = this.getModule(project);
            return new WebServiceResource(module, (IPath)webPath, unit);
        }
        return null;
    }

    private IModule getModule(IProject project) {
        IModule[] modules = ServerUtil.getModules((String)"jst.web");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String componentName = component.getName();
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule nextModule = iModuleArray[n2];
            if (nextModule.getName().equals(componentName)) {
                return nextModule;
            }
            ++n2;
        }
        return null;
    }
}

