/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.publish;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerLaunchableAdapterDelegate;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.publish.WebServiceResource;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;

public final class WebServiceLaunchableAdapter
extends LaunchableAdapterDelegate {
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTP_PROTOCOL = "http";
    private boolean useHttpsProtocol = false;
    private List<WeakReference<IModuleArtifact>> notifiedArtifacts = null;

    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        if (moduleArtifact instanceof WebServiceResource) {
            boolean redirectToUtc;
            WebServiceResource wsResource;
            block14: {
                wsResource = (WebServiceResource)moduleArtifact;
                redirectToUtc = false;
                try {
                    if (wsResource.getCompilationUnit().getTypes() != null && wsResource.getCompilationUnit().getTypes().length != 0) break block14;
                    return null;
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)((Object)e));
                    return null;
                }
            }
            IType type = wsResource.getCompilationUnit().getTypes()[0];
            boolean isIface = type.isInterface();
            boolean isAbstract = Flags.isAbstract((int)type.getFlags());
            if (isIface || isAbstract) {
                if (!this.notifiedForModuleArtifact(moduleArtifact)) {
                    String reason = isIface ? Messages.launchable_adapter_is_interface : Messages.launchable_adapter_is_abstract;
                    DialogService.showInfoDialog((String)Messages.launchable_adapter_not_runnable_title, (String)Messages.bind((String)Messages.launchable_adapter_not_runnable_msg, (Object)reason));
                }
                redirectToUtc = true;
            } else if (WebServiceProject.isWebServiceProvider(wsResource.getCompilationUnit(), true) && !WebServiceProject.hasWebServiceProviderWsdlLocationAttribute(wsResource.getCompilationUnit())) {
                return new WeblogicServerLaunchableAdapterDelegate().getLaunchable(server, (IModuleArtifact)wsResource);
            }
            Object launchableObj = new WeblogicServerLaunchableAdapterDelegate().getLaunchable(server, (IModuleArtifact)wsResource);
            if (launchableObj instanceof HttpLaunchable) {
                HttpLaunchable launchable = (HttpLaunchable)launchableObj;
                try {
                    URL launchURL;
                    WSRuntime runtime = (WSRuntime)((Object)wsResource.getModule().getProject().getAdapter(WSRuntime.class));
                    this.useHttpsProtocol = runtime.requiresHttpsTraffic();
                    IWeblogicServer iWsServer = this.wlsFromIServer(server);
                    if (WebServiceProject.isPolicyEnabled(wsResource.getCompilationUnit())) {
                        launchURL = this.forWSDL(iWsServer, launchable.getURL(), this.useHttpsProtocol);
                    } else {
                        String utc = this.getUTC(server);
                        launchURL = this.forUTC(iWsServer, launchable.getURL(), utc, !redirectToUtc, this.useHttpsProtocol);
                    }
                    return new HttpLaunchable(launchURL);
                }
                catch (UnsupportedEncodingException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
                }
                catch (MalformedURLException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private URL forUTC(IWeblogicServer wlsServer, URL url, String utc, boolean includeWsdl, boolean useHttpsProtocol) throws UnsupportedEncodingException, MalformedURLException {
        int httpsPort = 7002;
        ServerInfo info = null;
        if (wlsServer != null && (info = wlsServer.getServerInfo()) != null && (httpsPort = info.getHttpsPort()) == -1) {
            httpsPort = 7002;
        }
        String file = "/" + utc + "/";
        if (url != null) {
            if (useHttpsProtocol) {
                url = new URL(HTTPS_PROTOCOL, url.getHost(), httpsPort, url.getFile());
            }
            if (includeWsdl) {
                String wsdlUrl = String.valueOf(url.toString()) + "?WSDL";
                file = String.valueOf(file) + "?wsdlUrl=" + URLEncoder.encode(wsdlUrl, "utf-8");
            }
            if (useHttpsProtocol) {
                return new URL(HTTPS_PROTOCOL, url.getHost(), httpsPort, file);
            }
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        if (info != null) {
            if (useHttpsProtocol) {
                return new URL(HTTPS_PROTOCOL, info.getHostName(), httpsPort, file);
            }
            return new URL(HTTP_PROTOCOL, info.getHostName(), info.getPortNumber(), file);
        }
        return null;
    }

    private URL forWSDL(IWeblogicServer wlsServer, URL url, boolean useHttpsProtocol) throws UnsupportedEncodingException, MalformedURLException {
        int httpsPort = 7002;
        ServerInfo info = null;
        if (wlsServer != null && (info = wlsServer.getServerInfo()) != null && (httpsPort = info.getHttpsPort()) == -1) {
            httpsPort = 7002;
        }
        if (url != null) {
            if (useHttpsProtocol) {
                url = new URL(HTTPS_PROTOCOL, url.getHost(), httpsPort, url.getFile());
            }
            return url;
        }
        if (info != null) {
            String file = "";
            if (useHttpsProtocol) {
                return new URL(HTTPS_PROTOCOL, info.getHostName(), httpsPort, file);
            }
            return new URL(HTTP_PROTOCOL, info.getHostName(), info.getPortNumber(), file);
        }
        return null;
    }

    private IWeblogicServer wlsFromIServer(IServer server) {
        if (server == null) {
            return null;
        }
        if (server instanceof IWeblogicServer) {
            return (IWeblogicServer)server;
        }
        IWeblogicServer wlServer = null;
        Object adapter = server.getAdapter(IWeblogicServer.class);
        if (adapter != null && adapter instanceof IWeblogicServer) {
            wlServer = (IWeblogicServer)adapter;
        } else {
            adapter = server.loadAdapter(IWeblogicServer.class, null);
            if (adapter != null && adapter instanceof IWeblogicServer) {
                wlServer = (IWeblogicServer)adapter;
            }
        }
        return wlServer;
    }

    public URL getTestClientURL() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            IWeblogicServer wlServer = this.wlsFromIServer(server);
            if (wlServer != null && server.getServerState() == 2) {
                try {
                    String utc = this.getUTC(server);
                    return this.forUTC(wlServer, null, utc, false, this.useHttpsProtocol);
                }
                catch (UnsupportedEncodingException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
                }
                catch (MalformedURLException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
                }
            }
            ++n2;
        }
        return null;
    }

    private boolean notifiedForModuleArtifact(IModuleArtifact artifact) {
        boolean notified = false;
        if (this.notifiedArtifacts == null) {
            this.notifiedArtifacts = new ArrayList<WeakReference<IModuleArtifact>>();
        }
        Iterator<WeakReference<IModuleArtifact>> iter = this.notifiedArtifacts.iterator();
        while (iter.hasNext()) {
            WeakReference<IModuleArtifact> ref = iter.next();
            if (ref.get() == null) {
                iter.remove();
                continue;
            }
            if (ref.get() != artifact) continue;
            notified = true;
        }
        if (!notified) {
            this.notifiedArtifacts.add(new WeakReference<IModuleArtifact>(artifact));
        }
        return notified;
    }

    private String getUTC(IServer wlsServer) {
        IRuntime rt = wlsServer.getRuntime();
        WebLogicServerVersion version = WebLogicServerVersion.detect((IRuntime)rt);
        if (version.compareTo((Enum)WebLogicServerVersion.VERSION_12_1_2) < 0) {
            return "wls_utc";
        }
        return "ws_utc";
    }
}

