/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.wsdl.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.webservices.model.schema.ISchemaModel;
import oracle.eclipse.tools.webservices.model.wsdl.ISchema;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlAttribute;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class WsdlModelSchemaListController
extends StandardXmlListBindingImpl {
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(ISchemaModel.TYPE);
    private static final XmlPath PATH_SCHEMAS = new XmlPath("types");
    private static final String SCHEMA_ELEMENT_NAME = "schema";
    private static final String IMPORT_ELEMENT_NAME = "import";
    private static final Map<IPath, WeakReference<ISchemaModel>> schemaModels = new HashMap<IPath, WeakReference<ISchemaModel>>();

    protected void initBindingMetadata() {
        this.path = PATH_SCHEMAS;
        this.modelElementTypes = new ElementType[]{ISchemaModel.TYPE, ISchema.TYPE};
        this.xmlElementNames = new QName[this.modelElementTypes.length];
        this.xmlElementNames[0] = XmlUtil.createQualifiedName((String)SCHEMA_ELEMENT_NAME, (XmlNamespaceResolver)NAMESPACE_RESOLVER);
        this.xmlElementNames[1] = XmlUtil.createQualifiedName((String)SCHEMA_ELEMENT_NAME, (XmlNamespaceResolver)new StandardXmlNamespaceResolver(ISchema.TYPE));
    }

    public ElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        if (IMPORT_ELEMENT_NAME.equals(xmlElement.getDomNode().getLocalName())) {
            return ISchemaModel.TYPE;
        }
        return ISchema.TYPE;
    }

    protected Resource resource(Object obj) {
        String schemaLocation;
        XmlAttribute attribute;
        XmlElement xmlElement = (XmlElement)obj;
        if (IMPORT_ELEMENT_NAME.equals(xmlElement.getDomNode().getLocalName()) && (attribute = xmlElement.getAttribute("schemaLocation", false)) != null && !(schemaLocation = attribute.getText()).contains(":/")) {
            IFile file = (IFile)this.property().element().resource().adapt(IFile.class);
            IContainer container = file.getParent();
            IContainer parent = container.getParent();
            while (parent != null && schemaLocation.startsWith("../")) {
                schemaLocation = schemaLocation.substring(3);
                container = parent;
                parent = container.getParent();
            }
            assert (container != null);
            IFile schemaFile = container.getFile((IPath)new Path(schemaLocation));
            if (schemaFile != null && schemaFile.exists()) {
                try {
                    XmlResourceStore store = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(schemaFile));
                    return new ChildXmlResource((Resource)new RootXmlResource(store), xmlElement);
                }
                catch (ResourceStoreException resourceStoreException) {}
            }
        }
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        return new ChildXmlResource((Resource)parentXmlResource, xmlElement);
    }

    public List<ISchema> refresh(List<ISchema> content) {
        XmlElement parent = this.getParentXmlElement(false);
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList<XmlElement> xmlElements = new ArrayList<XmlElement>();
        for (XmlElement element : parent.getChildElements()) {
            String elementName = element.getDomNode().getLocalName();
            if (!SCHEMA_ELEMENT_NAME.equals(elementName)) continue;
            xmlElements.add(element);
            for (XmlElement schemaImport : element.getChildElements(IMPORT_ELEMENT_NAME)) {
                xmlElements.add(schemaImport);
            }
        }
        int newContentSize = xmlElements.size();
        boolean equal = content.size() == newContentSize;
        HashMap<XmlElement, ISchema> map = new HashMap<XmlElement, ISchema>();
        int index = 0;
        for (ISchema x : content) {
            XmlElement current;
            XmlResource xmlResource = (XmlResource)x.resource();
            XmlElement xmlElement = xmlResource.getXmlElement();
            if (equal && !(current = (XmlElement)xmlElements.get(index++)).equals((Object)xmlElement)) {
                equal = false;
            }
            map.put(xmlElement, x);
        }
        if (equal) {
            return content;
        }
        ArrayList<ISchema> newContent = new ArrayList<ISchema>(content.size());
        for (XmlElement xmlElement : xmlElements) {
            ISchema modelElement = (ISchema)map.get(xmlElement);
            if (modelElement == null) {
                modelElement = this.wrap(xmlElement);
            }
            if (modelElement == null) continue;
            newContent.add(modelElement);
        }
        return newContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISchema wrap(XmlElement element) {
        if (IMPORT_ELEMENT_NAME.equals(element.getDomNode().getLocalName())) {
            String schemaLocation;
            XmlAttribute attribute = element.getAttribute("schemaLocation", false);
            if (attribute != null && !(schemaLocation = attribute.getText()).contains(":/")) {
                IFile file = (IFile)this.property().element().resource().adapt(IFile.class);
                IContainer container = file.getParent();
                IContainer parent = container.getParent();
                while (parent != null && schemaLocation.startsWith("../")) {
                    schemaLocation = schemaLocation.substring(3);
                    container = parent;
                    parent = container.getParent();
                }
                assert (container != null);
                IFile schemaFile = container.getFile((IPath)new Path(schemaLocation));
                if (schemaFile != null && schemaFile.exists()) {
                    IPath path = schemaFile.getFullPath();
                    ISchemaModel schemaModel = null;
                    Map<IPath, WeakReference<ISchemaModel>> map = schemaModels;
                    synchronized (map) {
                        WeakReference<ISchemaModel> schemaModelRef = schemaModels.get(path);
                        if (schemaModelRef != null) {
                            schemaModel = (ISchemaModel)schemaModelRef.get();
                        }
                        if (schemaModel == null) {
                            schemaModel = (ISchemaModel)ISchemaModel.TYPE.instantiate(this.property(), this.property().element().resource());
                            schemaModel.setWsdlModel((IWsdlModel)this.property().element());
                            schemaModels.put(path, new WeakReference<ISchemaModel>(schemaModel));
                        }
                    }
                    return schemaModel;
                }
            }
            return null;
        }
        return (ISchema)ISchema.TYPE.instantiate((Property)this.property().element().property(IWsdlModel.PROP_SCHEMAS), this.property().element().resource());
    }

    public ISchema createNewElement(ElementType type) {
        return this.wrap(this.getParentXmlElement(true).addChildElement(SCHEMA_ELEMENT_NAME));
    }

    protected XmlElement getParentXmlElement(boolean createIfNecessary) {
        XmlElement parent = this.getXmlElement(createIfNecessary);
        if (parent != null) {
            parent = (XmlElement)parent.getChildNode(PATH_SCHEMAS, createIfNecessary);
        }
        return parent;
    }
}

