/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.wsdl.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.webservices.model.schema.ISchemaModel;
import oracle.eclipse.tools.webservices.model.wsdl.ISchema;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaElement;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaType;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessage;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import org.eclipse.sapphire.ElementList;

public final class WsdlModelDelegate {
    private static final Map<ISchemaModel, IWsdlModel> schemaToWsdlMap = new HashMap<ISchemaModel, IWsdlModel>();

    public static ISchemaType findType(IWsdlModel model, String name) {
        if (name == null) {
            return null;
        }
        for (ISchema schema : model.getSchemas()) {
            for (ISchemaType type : schema.getTypes()) {
                if (!name.equals(type.getTypeName().text())) continue;
                return type;
            }
        }
        return null;
    }

    public static ISchemaElement findElement(IWsdlModel model, String name) {
        if (name == null) {
            return null;
        }
        for (ISchema schema : model.getSchemas()) {
            for (ISchemaElement element : schema.getElements()) {
                if (!name.equals(element.getElementName().text())) continue;
                return element;
            }
        }
        return null;
    }

    public static IWsdlMessage findMessage(IWsdlModel model, String name) {
        if (name == null) {
            return null;
        }
        ElementList<IWsdlMessage> messages = model.getMessages();
        for (IWsdlMessage msg : messages) {
            if (!name.equals(msg.getMessageName().text())) continue;
            return msg;
        }
        return null;
    }

    public static IWsdlModel getWsdlModel(ISchema schema) {
        IWsdlModel model = (IWsdlModel)schema.nearest(IWsdlModel.class);
        if (model != null) {
            return model;
        }
        ISchemaModel schemaModel = (ISchemaModel)schema.nearest(ISchemaModel.class);
        return schemaToWsdlMap.get(schemaModel);
    }

    public static void setWsdlModel(ISchemaModel schemaModel, IWsdlModel wsdlModel) {
        schemaToWsdlMap.put(schemaModel, wsdlModel);
    }
}

