/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.reader;

import java.util.Arrays;
import java.util.List;
import oracle.eclipse.tools.webservices.model.reader.ASTAnnotation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public final class ASTMethod {
    private final String returnType;
    private final String name;
    private final String[] params;
    private final ASTAnnotation[] annotations;

    public ASTMethod(String theReturnType, String theName, List<String> theParams) {
        this(null, theReturnType, theName, theParams);
    }

    public ASTMethod(ASTAnnotation theAnnotation, String theReturnType, String theName, List<String> theParams) {
        this(theAnnotation, theReturnType, theName, theParams == null ? null : theParams.toArray(new String[theParams.size()]));
    }

    public ASTMethod(ASTAnnotation theAnnotation, String theReturnType, String theName, String ... theParams) {
        ASTAnnotation[] aSTAnnotationArray;
        assert (theName != null);
        this.returnType = theReturnType;
        this.name = theName;
        if (theParams == null) {
            this.params = null;
        } else {
            this.params = new String[theParams.length];
            System.arraycopy(theParams, 0, this.params, 0, theParams.length);
        }
        if (theAnnotation == null) {
            aSTAnnotationArray = new ASTAnnotation[]{};
        } else {
            ASTAnnotation[] aSTAnnotationArray2 = new ASTAnnotation[1];
            aSTAnnotationArray = aSTAnnotationArray2;
            aSTAnnotationArray2[0] = theAnnotation;
        }
        this.annotations = aSTAnnotationArray;
    }

    public MethodDeclaration findFirstMethodDeclaration(TypeDeclaration type) {
        MethodDeclaration[] methods;
        if (type == null) {
            return null;
        }
        MethodDeclaration[] methodDeclarationArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (this.isSameMethod(method)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof ASTMethod)) {
            return false;
        }
        ASTMethod method = (ASTMethod)o;
        if (!this.name.equals(method.name)) {
            return false;
        }
        if (this.annotations != null && method.annotations != null) {
            if (this.annotations.length != method.annotations.length) {
                return false;
            }
            i = 0;
            while (i < this.annotations.length) {
                if (!this.annotations[i].equals(method.annotations[i])) {
                    return false;
                }
                ++i;
            }
        }
        if (this.params != null) {
            if (method.params == null) {
                return false;
            }
            if (this.params.length != method.params.length) {
                return false;
            }
            i = 0;
            while (i < this.params.length) {
                if (!this.params[i].equals(method.params[i])) {
                    return false;
                }
                ++i;
            }
        }
        return this.returnType == null || this.returnType.equals(method.returnType);
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        Object[] objectArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            ASTAnnotation annotation = objectArray[n2];
            hash += annotation.hashCode();
            ++n2;
        }
        if (this.params != null) {
            objectArray = this.params;
            n = this.params.length;
            n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                hash += ((String)param).hashCode();
                ++n2;
            }
        }
        if (this.returnType != null) {
            hash += this.returnType.hashCode();
        }
        return hash;
    }

    private boolean isSameMethod(MethodDeclaration method) {
        IMethodBinding methodBinding = method.resolveBinding();
        if (methodBinding != null) {
            if (!methodBinding.getName().equals(this.name)) {
                return false;
            }
            if (this.params != null && !this.isSameParameters(this.params, methodBinding.getParameterTypes())) {
                return false;
            }
            if (this.returnType != null && !this.isSameType(this.returnType, methodBinding.getReturnType())) {
                return false;
            }
        } else {
            ITypeBinding binding;
            Boolean same;
            if (!method.getName().getFullyQualifiedName().equals(this.name)) {
                return false;
            }
            if (this.params != null && (same = this.isSameParameters(this.params, method.parameters())) != null && !same.booleanValue()) {
                return false;
            }
            if (this.returnType != null && (binding = method.getReturnType2().resolveBinding()) != null && !this.isSameType(this.returnType, binding)) {
                return false;
            }
        }
        return true;
    }

    private Boolean isSameParameters(String[] typeNames, List<?> types) {
        if (typeNames.length != types.size()) {
            return false;
        }
        int i = 0;
        while (i < typeNames.length) {
            SimpleType simple;
            SingleVariableDeclaration svd = (SingleVariableDeclaration)types.get(i);
            ITypeBinding binding = svd.getType().resolveBinding();
            if (binding == null ? svd.getType() instanceof SimpleType && !typeNames[i].equals((simple = (SimpleType)svd.getType()).getName().getFullyQualifiedName()) : !this.isSameType(typeNames[i], binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSameParameters(String[] typeNames, ITypeBinding[] types) {
        if (typeNames.length != types.length) {
            return false;
        }
        int i = 0;
        while (i < typeNames.length) {
            if (!this.isSameType(typeNames[i], types[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSameType(String name, ITypeBinding binding) {
        assert (binding != null);
        assert (name != null);
        return name.equals(binding.getQualifiedName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ASTAnnotation[] aSTAnnotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            ASTAnnotation annotation = aSTAnnotationArray[n2];
            sb.append(annotation.toString()).append(' ');
            ++n2;
        }
        return "ASTMethod [" + sb.toString() + "] " + this.returnType + " " + this.name + "(" + Arrays.toString(this.params) + ")";
    }
}

