/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.net.URI;
import java.net.URISyntaxException;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.model.WsdlModelValidator;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelGroupResource;
import oracle.eclipse.tools.webservices.model.schema.ISchemaModel;
import oracle.eclipse.tools.webservices.model.wsdl.ISchema;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlAttribute;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.services.ValidationService;

public final class URIValidator
extends ValidationService {
    protected Status compute() {
        Value target = (Value)this.context(Value.class);
        String uriString = target.text();
        if (uriString == null) {
            return Status.createErrorStatus((String)"Null URI");
        }
        try {
            new URI(uriString);
        }
        catch (URISyntaxException e) {
            return Status.createErrorStatus((String)e.getMessage());
        }
        JWSModelGroup group = (JWSModelGroup)target.element().nearest(JWSModelGroup.class);
        if (group != null) {
            IWsdlModel wsdlModel = ((JWSModelGroupResource)group.resource()).getWsdlModel();
            if (wsdlModel == null) {
                return Status.createErrorStatus((String)Messages.bind((String)Messages.wsdl_not_found, (Object)uriString));
            }
            IFile f = (IFile)wsdlModel.resource().adapt(IFile.class);
            if (!f.exists()) {
                return Status.createErrorStatus((String)Messages.bind((String)Messages.wsdl_not_found, (Object)f.getLocation()));
            }
            ElementList<ISchema> schemas = wsdlModel.getSchemas();
            for (ISchema schema : schemas) {
                XmlResource xmlResource;
                XmlElement element;
                if (schema instanceof ISchemaModel || !"import".equals((element = (xmlResource = (XmlResource)schema.resource()).getXmlElement()).getDomNode().getLocalName())) continue;
                XmlAttribute attribute = element.getAttribute("schemaLocation", false);
                if (attribute != null) {
                    String schemaLocation = attribute.getText();
                    return Status.createErrorStatus((String)Messages.bind((String)Messages.schema_not_found, (Object)schemaLocation), null);
                }
                return Status.createErrorStatus((String)Messages.scheme_import_not_supported);
            }
            IStatus status = WsdlModelValidator.validate(f);
            if (status.isOK()) {
                return Status.createStatus((Status.Severity)Status.Severity.OK, (String)status.getMessage());
            }
            return Status.createErrorStatus((String)status.getMessage());
        }
        return Status.createErrorStatus((String)Messages.bind((String)Messages.wsdl_not_found, (Object)uriString));
    }
}

