/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperation;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameter;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameterInput;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;

public final class PartNameDefaultValueProvider
extends DefaultValueService {
    protected DefaultValueServiceData compute() {
        ValueProperty property = (ValueProperty)this.context(ValueProperty.class);
        Element modelElement = (Element)this.context(Element.class);
        if (modelElement != null) {
            return new DefaultValueServiceData(this.getDefaultValue(modelElement, property));
        }
        return null;
    }

    private String getDefaultValue(Element modelElement, ValueProperty property) {
        assert (modelElement instanceof IWsdlOperationParameter);
        assert (property == IWsdlOperationParameter.PROP_NAME);
        IWsdlOperationParameter param = (IWsdlOperationParameter)modelElement;
        IWsdlOperation operation = (IWsdlOperation)param.nearest(IWsdlOperation.class);
        ElementList<IWsdlOperationParameter> params = operation.getOperationParams();
        boolean hasInput = false;
        boolean hasOutput = false;
        for (IWsdlOperationParameter wsdlParam : params) {
            if (wsdlParam instanceof IWsdlOperationParameterInput) {
                hasInput = true;
                continue;
            }
            hasOutput = true;
        }
        String operationName = operation.getOperationName().text();
        if (!hasInput && hasOutput) {
            throw new IllegalStateException("JAX-WS doesn't support notification message");
        }
        if (hasInput && !hasOutput) {
            return operationName;
        }
        if (param instanceof IWsdlOperationParameterInput) {
            return String.valueOf(operationName) + "Request";
        }
        return String.valueOf(operationName) + "Response";
    }
}

