/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IDefinitions;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSJavaPackage;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsPropertyDef2;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.PackageNameDefaultProvider;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.xml.XmlElement;

public final class JavaPackageResource
extends Resource {
    private final JWSModelGroup group;
    private JWSModelElement<JavaPackageResource, IWsdlModel, IDefinitions> definitionsElement;
    private BindingsPropertyDef2<JavaPackageResource, IWsdlModel, IDefinitions, Value<String>> name;
    private BindingsPropertyDef2<JavaPackageResource, IWsdlModel, IDefinitions, Value<String>> javadoc;

    public JavaPackageResource(JWSModelGroup group, Resource resource) {
        super(resource);
        this.group = group;
    }

    public void init(Element element) {
        super.init(element);
        this.definitionsElement = new JWSModelElement<JavaPackageResource, IWsdlModel, IDefinitions>(null, null, NodeNameBinding.Patterns.definitions){

            @Override
            protected JWSJavaPackage getModelElement() {
                return (JWSJavaPackage)JavaPackageResource.this.element();
            }

            @Override
            protected IDefinitions createNewBindings() {
                return (IDefinitions)((IBindingsSet)JavaPackageResource.this.group.getBindingsSet().content()).getDefinitions().insert();
            }

            @Override
            protected List<IDefinitions> getBindingsElements() {
                if (JavaPackageResource.this.group.getBindingsSet().content() != null) {
                    return ((IBindingsSet)JavaPackageResource.this.group.getBindingsSet().content()).getDefinitions();
                }
                return Collections.emptyList();
            }

            @Override
            protected List<IInvalid> getInvalidElements() {
                return ((IBindingsSet)JavaPackageResource.this.group.getBindingsSet().content()).getInvalids();
            }
        };
        this.name = new BindingsPropertyDef2(this.definitionsElement, IDefinitions.PROP_PACKAGE_NAME, null, JWSJavaPackage.PROP_NAME);
        this.javadoc = new BindingsPropertyDef2(this.definitionsElement, IDefinitions.PROP_PACKAGE_JAVADOC, null, JWSJavaPackage.PROP_JAVA_DOC, this.name);
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSJavaPackage.PROP_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JavaPackageResource.this.getName();
                }

                public void write(String value) {
                    JavaPackageResource.this.setName(value);
                }
            };
        }
        if (p == JWSJavaPackage.PROP_JAVA_DOC) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JavaPackageResource.this.getJavaDoc();
                }

                public void write(String value) {
                    JavaPackageResource.this.setJavaDoc(value);
                }
            };
        }
        if (p == JWSJavaPackage.PROP_TARGET_NAMESPACE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JavaPackageResource.this.getTargetNamespace();
                }

                public void write(String value) {
                    JavaPackageResource.this.setTargetNamespace(value);
                }
            };
        }
        return null;
    }

    public boolean canSetJavaDoc() {
        return true;
    }

    public boolean canSetName() {
        return true;
    }

    public boolean canSetTargetNamespace() {
        return false;
    }

    public String getJavaDoc() {
        return this.javadoc.get();
    }

    public String getName() {
        return this.name.get();
    }

    public String getTargetNamespace() {
        return new PackageNameDefaultProvider().getTargetNameSpace(this.group);
    }

    public void setJavaDoc(String doc) {
        this.javadoc.set(doc);
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public void setTargetNamespace(String namespace) {
    }

    public XmlElement getXmlElement() {
        return null;
    }
}

