/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webservices.model.bindings.IBinding;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IService;
import oracle.eclipse.tools.webservices.model.bindings.IServicePort;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSService;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsModelListController2;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelGroupResource;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSServiceResource;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlBinding;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlPort;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlService;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Resource;

public class JWSServiceListController
extends ListPropertyBinding {
    private final JWSModel parent;
    private final Resource resource;
    private Map<String, JWSServiceResource> current = new LinkedHashMap<String, JWSServiceResource>();
    private final BindingsModelListController2<IWsdlModel, IBindingsSet, JWSServiceResource, IWsdlBinding, IBinding> bindingsList = new BindingsModelListController2<IWsdlModel, IBindingsSet, JWSServiceResource, IWsdlBinding, IBinding>(IBinding.PROP_BINDING_NAME, IWsdlBinding.PROP_NAME, IBindingsSet.PROP_BINDINGS, IWsdlModel.PROP_BINDINGS, NodeNameBinding.Patterns.binding){

        @Override
        JWSModelElement<JWSServiceResource, IWsdlBinding, IBinding> adaptToJWSModelElement(JWSServiceResource model) {
            return model.bindingElement;
        }

        @Override
        JWSServiceResource create() {
            return new JWSServiceResource(JWSServiceListController.this.parent, JWSServiceListController.this.parent.resource());
        }

        IBindingsSet[] getBindingListParents() {
            return new IBindingsSet[]{((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getBindingsSet()};
        }

        IWsdlModel[] getWsdlListParents() {
            return new IWsdlModel[]{((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getWsdlModel()};
        }

        @Override
        protected boolean filterWsdlElement(IWsdlBinding element) {
            if (element == null) {
                return false;
            }
            String portTypeName = JWSServiceListController.this.parent.getServiceName().text();
            if (portTypeName == null) {
                return false;
            }
            return portTypeName.equals(element.getTypeName().text());
        }

        @Override
        protected boolean filterBindingsElement(IBinding binding) {
            String bindingName = binding.getBindingName().text();
            return JWSServiceListController.this.filterBindingName(bindingName);
        }
    };
    private final BindingsModelListController2<IWsdlModel, IBindingsSet, JWSServiceResource, IWsdlService, IService> servicesList = new BindingsModelListController2<IWsdlModel, IBindingsSet, JWSServiceResource, IWsdlService, IService>(IService.PROP_SERVICE_NAME, IWsdlService.PROP_NAME, IBindingsSet.PROP_SERVICES, IWsdlModel.PROP_SERVICES, NodeNameBinding.Patterns.service){

        IWsdlModel[] getWsdlListParents() {
            return new IWsdlModel[]{((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getWsdlModel()};
        }

        IBindingsSet[] getBindingListParents() {
            return new IBindingsSet[]{((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getBindingsSet()};
        }

        @Override
        JWSServiceResource create() {
            return new JWSServiceResource(JWSServiceListController.this.parent, JWSServiceListController.this.resource);
        }

        @Override
        JWSModelElement<JWSServiceResource, IWsdlService, IService> adaptToJWSModelElement(JWSServiceResource model) {
            return model.serviceElement;
        }

        @Override
        protected boolean filterWsdlElement(IWsdlService wsdlService) {
            for (IWsdlPort port : wsdlService.getPorts()) {
                if (!JWSServiceListController.this.filterPortName(port.getName().text())) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean filterBindingsElement(IService service) {
            String serviceName = service.getServiceName().text();
            if (serviceName == null) {
                return false;
            }
            IWsdlModel wsdlModel = ((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getWsdlModel();
            if (wsdlModel == null) {
                return false;
            }
            ElementList<IWsdlService> services = wsdlModel.getServices();
            for (IWsdlService wsdlService : services) {
                if (!serviceName.equals(wsdlService.getName().text())) continue;
                for (IWsdlPort port : wsdlService.getPorts()) {
                    if (!JWSServiceListController.this.filterPortName(port.getName().text())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    };
    private final BindingsModelListController2<IWsdlService, IBindingsSet, JWSServiceResource, IWsdlPort, IServicePort> portList = new BindingsModelListController2<IWsdlService, IBindingsSet, JWSServiceResource, IWsdlPort, IServicePort>(IServicePort.PROP_PORT_NAME, IWsdlPort.PROP_NAME, IBindingsSet.PROP_SERVICE_PORTS, IWsdlService.PROP_PORTS, NodeNameBinding.Patterns.port){

        IWsdlService[] getWsdlListParents() {
            IWsdlModel wsdlModel = ((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getWsdlModel();
            if (wsdlModel != null) {
                ElementList<IWsdlService> services = wsdlModel.getServices();
                return services.toArray((IWsdlService[])new IWsdlService[services.size()]);
            }
            return new IWsdlService[0];
        }

        IBindingsSet[] getBindingListParents() {
            return new IBindingsSet[]{((JWSModelGroupResource)JWSServiceListController.this.parent.parent().element().resource()).getBindingsSet()};
        }

        @Override
        JWSServiceResource create() {
            return new JWSServiceResource(JWSServiceListController.this.parent, JWSServiceListController.this.parent.resource());
        }

        @Override
        JWSModelElement<JWSServiceResource, IWsdlPort, IServicePort> adaptToJWSModelElement(JWSServiceResource model) {
            return model.portElement;
        }

        @Override
        protected boolean filterWsdlElement(IWsdlPort element) {
            String bindingName = element.getBindingName().text();
            return JWSServiceListController.this.filterBindingName(bindingName);
        }

        @Override
        protected boolean filterBindingsElement(IServicePort port) {
            String portName = port.getPortName().text();
            return JWSServiceListController.this.filterPortName(portName);
        }
    };

    public JWSServiceListController(JWSModel parent, Resource resource) {
        this.parent = parent;
        this.resource = resource;
    }

    private boolean filterBindingName(String bindingName) {
        String portTypeName = this.parent.getServiceName().text();
        if (portTypeName == null) {
            return false;
        }
        if (bindingName == null) {
            return false;
        }
        IWsdlModel wsdlModel = ((JWSModelGroupResource)this.parent.parent().element().resource()).getWsdlModel();
        if (wsdlModel != null) {
            ElementList<IWsdlBinding> bindings = wsdlModel.getBindings();
            for (IWsdlBinding wsdlBinding : bindings) {
                if (!bindingName.equals(wsdlBinding.getName().text())) continue;
                return portTypeName.equals(wsdlBinding.getTypeName().text());
            }
        }
        return false;
    }

    private boolean filterPortName(String portName) {
        if (portName == null) {
            return false;
        }
        IWsdlModel wsdlModel = ((JWSModelGroupResource)this.parent.parent().element().resource()).getWsdlModel();
        if (wsdlModel == null) {
            return false;
        }
        ElementList<IWsdlService> services = wsdlModel.getServices();
        for (IWsdlService service : services) {
            for (IWsdlPort wsdlPort : service.getPorts()) {
                if (!portName.equals(wsdlPort.getName().text())) continue;
                String bindingName = wsdlPort.getBindingName().text();
                return this.filterBindingName(bindingName);
            }
        }
        return false;
    }

    public ElementType type(Resource resource) {
        return JWSService.TYPE;
    }

    public List<Resource> read() {
        if (this.current.isEmpty()) {
            LinkedHashMap updates = new LinkedHashMap(this.current.size());
            this.bindingsList.refresh(this.current, updates);
            LinkedHashMap<String, JWSServiceResource> ports = new LinkedHashMap<String, JWSServiceResource>(this.current.size());
            for (JWSServiceResource model : updates.values()) {
                ports.put(model.getPortName(), model);
            }
            updates.clear();
            this.portList.refresh(ports, updates);
            LinkedHashMap<String, JWSServiceResource> services = new LinkedHashMap<String, JWSServiceResource>(this.current.size());
            for (JWSServiceResource model : updates.values()) {
                services.put(model.getServiceName(), model);
            }
            updates.clear();
            this.servicesList.refresh(services, updates);
            this.current.clear();
            for (String key : updates.keySet()) {
                this.current.put(key, (JWSServiceResource)((Object)updates.get(key)));
            }
        }
        return new ArrayList<Resource>(this.current.values());
    }
}

