/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperationFault;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSFault;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.internal.AbstractJWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsPropertyDef2;
import oracle.eclipse.tools.webservices.model.jws.internal.FaultListController;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationParameterListController;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaComplexType;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaElement;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaType;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessage;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessagePart;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperation;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationFault;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameter;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameterInput;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.xml.XmlResource;

public final class JWSOperationResource
extends AbstractJWSModelElement {
    private BindingsPropertyDef2<JWSOperationResource, IWsdlOperation, IPortTypeOperation, Value<String>> methodName;
    private BindingsPropertyDef2<JWSOperationResource, IWsdlOperation, IPortTypeOperation, Value<String>> javaDoc;
    private BindingsPropertyDef2<JWSOperationResource, IWsdlOperation, IPortTypeOperation, Value<Boolean>> wrapperStyleEnabled;
    private BindingsPropertyDef2<JWSOperationResource, IWsdlOperation, IPortTypeOperation, Value<Boolean>> asyncEnabled;
    private final JWSModel parent;
    final JWSModelElement<JWSOperationResource, IWsdlOperation, IPortTypeOperation> operationElement = new JWSModelElement<JWSOperationResource, IWsdlOperation, IPortTypeOperation>(IWsdlOperation.PROP_OPERATION_NAME, IPortTypeOperation.PROP_OPERATION_NAME, NodeNameBinding.Patterns.portTypeOperation){

        @Override
        public IPortTypeOperation createNewBindings() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationResource.this.element().nearest(JWSModelGroup.class);
            IPortTypeOperation operation = (IPortTypeOperation)((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getOperations().insert();
            operation.setPortTypeName(JWSOperationResource.this.parent.getServiceName().text());
            IWsdlOperation wsdlOperation = JWSOperationResource.this.operationElement.getWsdlModelElement();
            if (wsdlOperation != null) {
                operation.setOperationName(wsdlOperation.getOperationName().text());
            }
            return operation;
        }

        @Override
        public JWSOperation getModelElement() {
            return (JWSOperation)JWSOperationResource.this.element();
        }

        @Override
        protected List<IPortTypeOperation> getBindingsElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationResource.this.element().nearest(JWSModelGroup.class);
            ElementList<IPortTypeOperation> operationBindings = ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getOperations();
            ArrayList<IPortTypeOperation> list = new ArrayList<IPortTypeOperation>();
            IWsdlOperation wsdlOperation = JWSOperationResource.this.operationElement.getWsdlModelElement();
            if (wsdlOperation != null) {
                for (IPortTypeOperation portTypeOperation : operationBindings) {
                    if (portTypeOperation.getOperationName() == null || wsdlOperation.getOperationName() == null || !wsdlOperation.getOperationName().text().equals(portTypeOperation.getOperationName().text())) continue;
                    list.add(portTypeOperation);
                    return Collections.unmodifiableList(list);
                }
            }
            return Collections.emptyList();
        }

        @Override
        protected void clearBindingsElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationResource.this.element().nearest(JWSModelGroup.class);
            ElementList<IPortTypeOperation> operationBindings = ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getOperations();
            List<IPortTypeOperation> operationBindingsToRemove = this.getBindingsElements();
            for (IPortTypeOperation portOp : operationBindingsToRemove) {
                operationBindings.remove(portOp);
            }
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationResource.this.element().nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getInvalids();
        }
    };
    final JWSModelElement<JWSOperationResource, IWsdlOperationFault, IPortTypeOperationFault> faultElement = new JWSModelElement<JWSOperationResource, IWsdlOperationFault, IPortTypeOperationFault>(null, IPortTypeOperationFault.PROP_OPERATION_NAME, NodeNameBinding.Patterns.portTypeOperation){

        @Override
        public IPortTypeOperationFault createNewBindings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JWSOperation getModelElement() {
            return (JWSOperation)JWSOperationResource.this.element();
        }

        @Override
        protected List<IPortTypeOperationFault> getBindingsElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationResource.this.element().nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getFaults();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationResource.this.element().nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getInvalids();
        }
    };

    static {
        JWSOperationResource.addKeyProperty(JWSOperationParameter.PROP_NAME, JWSOperation.PROP_PARAMETERS);
        JWSOperationResource.addKeyProperty(JWSFault.PROP_FAULT_NAME, JWSOperation.PROP_FAULTS);
    }

    public JWSOperationResource(JWSModel model, Resource resource) {
        super(resource);
        this.parent = model;
    }

    public void init(Element element) {
        super.init(element);
        this.methodName = new BindingsPropertyDef2(this.operationElement, IPortTypeOperation.PROP_METHOD_NAME, null, JWSOperation.PROP_METHOD_NAME);
        this.javaDoc = new BindingsPropertyDef2(this.operationElement, IPortTypeOperation.PROP_JAVADOC, null, JWSOperation.PROP_JAVA_DOC, this.methodName);
        this.wrapperStyleEnabled = new BindingsPropertyDef2(this.operationElement, IPortTypeOperation.PROP_ENABLE_WRAPPER_STYLE, null, JWSOperation.PROP_WRAPPER_STYLE_ENABLED);
        this.asyncEnabled = new BindingsPropertyDef2(this.operationElement, IPortTypeOperation.PROP_ENABLE_ASYNC_MAPPING, null, JWSOperation.PROP_ASYNC_ENABLED);
        this.addModelElement(this.operationElement, JWSOperation.PROP_OPERATION_NAME);
        this.addModelElement(this.faultElement, JWSOperation.PROP_OPERATION_NAME);
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSOperation.PROP_METHOD_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.getMethodName();
                }

                public void write(String value) {
                    JWSOperationResource.this.setMethodName(value);
                }
            };
        }
        if (p == JWSOperation.PROP_JAVA_DOC) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.getJavaDoc();
                }

                public void write(String value) {
                    JWSOperationResource.this.setJavaDoc(value);
                }
            };
        }
        if (p == JWSOperation.PROP_WRAPPER_STYLE_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.isWrapperStyleEnabled();
                }

                public void write(String value) {
                    JWSOperationResource.this.setWrapperStyleEnabled(value);
                }
            };
        }
        if (p == JWSOperation.PROP_ASYNC_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.isAsyncEnabled();
                }

                public void write(String value) {
                    JWSOperationResource.this.setAsyncEnabled(value);
                }
            };
        }
        if (p == JWSOperation.PROP_OPERATION_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.getOperationName();
                }

                public void write(String value) {
                    JWSOperationResource.this.setOperationName(value);
                }
            };
        }
        if (p == JWSOperation.PROP_FAULTS) {
            return new FaultListController((JWSOperation)this.element());
        }
        if (p == JWSOperation.PROP_PARAMETERS) {
            return new JWSOperationParameterListController((JWSOperation)this.element(), this);
        }
        if (p == JWSOperation.PROP_ONE_WAY) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.isOneWay();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperation.PROP_WRAPPER_STYLE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.isWrapperStyle();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperation.PROP_RETURN_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationResource.this.getReturnType();
                }

                public void write(String value) {
                }
            };
        }
        return null;
    }

    public String getJavaDoc() {
        return this.javaDoc.get();
    }

    public String getMethodName() {
        return this.methodName.get();
    }

    public String isOneWay() {
        boolean isOneWay = true;
        IWsdlOperation wsdlOperation = this.operationElement.getWsdlModelElement();
        if (wsdlOperation != null) {
            ElementList<IWsdlOperationParameter> params = wsdlOperation.getOperationParams();
            for (IWsdlOperationParameter param : params) {
                XmlResource xmlResource = (XmlResource)param.resource();
                String localName = xmlResource.getXmlElement(false).getLocalName();
                if ("input".equals(localName)) continue;
                isOneWay = false;
                break;
            }
        }
        return Boolean.toString(isOneWay);
    }

    public String getOperationName() {
        return this.getKeyValue();
    }

    public void setOperationName(String name) {
        this.operationElement.setKeyBindingValue(name);
        for (JWSFault fault : ((JWSOperation)this.element()).getFaults()) {
            fault.setOperationName(name);
        }
        this.parent.getOperations().refresh();
    }

    public void setServiceName(String name) {
        this.operationElement.setBindingValue(IPortTypeOperation.PROP_PORT_TYPE_NAME, name);
        for (JWSFault fault : ((JWSOperation)this.element()).getFaults()) {
            fault.setServiceName(name);
        }
        this.element().property(JWSOperation.PROP_PARAMETERS).refresh();
        this.element().property(JWSOperation.PROP_FAULTS).refresh();
    }

    public String getServiceName() {
        return null;
    }

    public String getReturnType() {
        return null;
    }

    private boolean isWrapperStyleInternal() {
        IWsdlOperation wsdlOperation = this.operationElement.getWsdlModelElement();
        if (wsdlOperation != null) {
            Boolean value = (Boolean)this.element().property(JWSOperation.PROP_WRAPPER_STYLE_ENABLED).content(true);
            if (value == null || !value.booleanValue()) {
                return false;
            }
            IWsdlModel model = (IWsdlModel)wsdlOperation.nearest(IWsdlModel.class);
            for (IWsdlOperationParameter param : wsdlOperation.getOperationParams()) {
                XmlResource xmlResource;
                ISchemaType type;
                IWsdlMessage message = model.findMessage(param.getMessageName().text());
                if (message == null) {
                    return false;
                }
                ElementList<IWsdlMessagePart> parts = message.getMessageParts();
                if (parts.size() != 1) {
                    return false;
                }
                IWsdlMessagePart part = (IWsdlMessagePart)parts.get(0);
                String elementName = part.getElementName().text();
                if (elementName == null) {
                    return false;
                }
                String operationName = this.getOperationName();
                if (param instanceof IWsdlOperationParameterInput && !elementName.equals(operationName)) {
                    return false;
                }
                ISchemaElement se = model.findElement(elementName);
                if (se == null) {
                    return false;
                }
                String typeName = se.getTypeName().text();
                if (typeName == null) {
                    type = (ISchemaComplexType)se.getComplexType().content();
                    if (type == null) {
                        return false;
                    }
                    xmlResource = (XmlResource)type.resource();
                    if (xmlResource.getXmlElement().getChildElement("sequence", false) != null) continue;
                    return false;
                }
                type = model.findType(se.getTypeName().text());
                if (!(type instanceof ISchemaComplexType)) {
                    return false;
                }
                xmlResource = (XmlResource)type.resource();
                if (xmlResource.getXmlElement().getChildElement("sequence", false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public String isWrapperStyle() {
        return Boolean.toString(this.isWrapperStyleInternal());
    }

    public String isWrapperStyleEnabled() {
        return this.wrapperStyleEnabled.get();
    }

    public String isAsyncEnabled() {
        return this.asyncEnabled.get();
    }

    public void setJavaDoc(String doc) {
        this.javaDoc.set(doc);
    }

    public void setMethodName(String name) {
        this.methodName.set(name);
    }

    public void setWrapperStyleEnabled(Boolean enable) {
        this.wrapperStyleEnabled.set(enable);
        this.element().property(JWSOperation.PROP_PARAMETERS).refresh();
    }

    public void setWrapperStyleEnabled(String enable) {
        this.wrapperStyleEnabled.set(enable);
        this.element().property(JWSOperation.PROP_PARAMETERS).refresh();
    }

    public void setAsyncEnabled(Boolean enable) {
        this.asyncEnabled.set(enable);
    }

    public void setAsyncEnabled(String enable) {
        this.asyncEnabled.set(enable);
    }

    public void removeOperationBinding() {
        this.operationElement.removeBinding();
        this.element().property(JWSOperation.PROP_METHOD_NAME).refresh();
        this.parent.property(JWSModel.PROP_OPERATIONS).refresh();
        this.element().property(JWSOperation.PROP_PARAMETERS).refresh();
        this.element().property(JWSOperation.PROP_FAULTS).refresh();
    }
}

