/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.IOperationParameter;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.internal.AbstractJWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationResource;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaElement;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessage;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessagePart;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameter;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameterInput;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameterOutput;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JWSOperationParameterResource
extends AbstractJWSModelElement {
    private final JWSOperation operation;
    private ISchemaElement schemaElement;
    private IWsdlOperationParameter wsdlParameter;
    private Boolean rebroadcast = true;
    final JWSModelElement<JWSOperationParameterResource, IWsdlMessagePart, IOperationParameter> partElement = new JWSModelElement<JWSOperationParameterResource, IWsdlMessagePart, IOperationParameter>(IWsdlMessagePart.PROP_PART_NAME, IOperationParameter.PROP_PART_NAME, NodeNameBinding.Patterns.messagePart){

        @Override
        protected JWSOperationParameter getModelElement() {
            return (JWSOperationParameter)JWSOperationParameterResource.this.element();
        }

        @Override
        protected IOperationParameter createNewBindings() {
            List<IPortTypeOperation> parentBindings = ((JWSOperationResource)((JWSOperationParameterResource)JWSOperationParameterResource.this).operation.resource()).operationElement.getBindingsElements();
            IPortTypeOperation parentBinding = null;
            parentBinding = parentBindings.isEmpty() ? ((JWSOperationResource)((JWSOperationParameterResource)JWSOperationParameterResource.this).operation.resource()).operationElement.createNewBindings() : parentBindings.get(0);
            IOperationParameter param = (IOperationParameter)parentBinding.getParameters().insert();
            return param;
        }

        @Override
        public void removeBinding() {
            List<IPortTypeOperation> parentBindings = ((JWSOperationResource)((JWSOperationParameterResource)JWSOperationParameterResource.this).operation.resource()).operationElement.getBindingsElements();
            IPortTypeOperation parentBinding = null;
            if (parentBindings.isEmpty()) {
                return;
            }
            parentBinding = parentBindings.get(0);
            List<IOperationParameter> bindings = JWSOperationParameterResource.this.partElement.getBindingsElements();
            IOperationParameter param = null;
            if (bindings.isEmpty()) {
                return;
            }
            param = bindings.get(0);
            parentBinding.getParameters().remove((Object)param);
            this.clearBindingsElements();
        }

        @Override
        protected List<IOperationParameter> getBindingsElements() {
            List<IPortTypeOperation> parentBindings = ((JWSOperationResource)((JWSOperationParameterResource)JWSOperationParameterResource.this).operation.resource()).operationElement.getBindingsElements();
            IPortTypeOperation parentBinding = null;
            if (parentBindings.isEmpty()) {
                return Collections.emptyList();
            }
            parentBinding = parentBindings.get(0);
            ElementList<IOperationParameter> params = parentBinding.getParameters();
            IWsdlMessagePart part = JWSOperationParameterResource.this.partElement.getWsdlModelElement();
            IWsdlMessage message = (IWsdlMessage)part.nearest(IWsdlMessage.class);
            ArrayList<IOperationParameter> thisParamList = new ArrayList<IOperationParameter>();
            for (IOperationParameter param : params) {
                String elementName;
                if (!message.getMessageName().text().equals(param.getMessageName().text()) || !part.getPartName().text().equals(param.getPartName().text()) || (elementName = JWSOperationParameterResource.this.getChildElementName(param)) == null || !elementName.equals(param.getType().text())) continue;
                thisParamList.add(param);
                return Collections.unmodifiableList(thisParamList);
            }
            return Collections.emptyList();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationParameterResource.this.operation.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getInvalids();
        }
    };

    public JWSOperationParameterResource(JWSOperation operation, Resource resource) {
        super(resource);
        this.operation = operation;
        this.addModelElement(this.partElement, JWSOperationParameter.PROP_NAME);
    }

    public void init(org.eclipse.sapphire.Element element) {
        super.init(element);
        List<IOperationParameter> bindings = this.partElement.getBindingsElements();
        IOperationParameter param = null;
        if (!bindings.isEmpty()) {
            param = bindings.get(0);
            param.getName().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleTypedEvent(PropertyContentEvent event) {
                    JWSOperationParameterResource jWSOperationParameterResource = JWSOperationParameterResource.this;
                    synchronized (jWSOperationParameterResource) {
                        if (!JWSOperationParameterResource.this.rebroadcast.booleanValue()) {
                            return;
                        }
                    }
                    JWSOperationParameterResource.this.element().property(JWSOperationParameter.PROP_NAME).refresh();
                }
            });
        }
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSOperationParameter.PROP_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.getName();
                }

                public void write(String value) {
                    JWSOperationParameterResource.this.setName(value);
                }
            };
        }
        if (p == JWSOperationParameter.PROP_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.getType();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperationParameter.PROP_MESSAGE_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.getMessageName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperationParameter.PROP_ELEMENT_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.getElementName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperationParameter.PROP_IN) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.isIn();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperationParameter.PROP_OUT) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.isOut();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperationParameter.PROP_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.getType();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSOperationParameter.PROP_PART_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSOperationParameterResource.this.getPartName();
                }

                public void write(String value) {
                }
            };
        }
        return null;
    }

    void setSchemaElement(ISchemaElement e) {
        this.schemaElement = e;
    }

    ISchemaElement getSchemaElement() {
        return this.schemaElement;
    }

    void setWsdlParameter(IWsdlOperationParameter wsdl) {
        this.wsdlParameter = wsdl;
    }

    public String getName() {
        String name = null;
        for (IOperationParameter param : this.partElement.getBindingsElements()) {
            name = param.getName().text();
            if (name != null) break;
        }
        return name;
    }

    public String getType() {
        return this.schemaElement == null ? null : this.schemaElement.getJavaType().text();
    }

    public void setName(String name) {
        if (ObjectUtil.equal((Object)name, (Object)this.getName())) {
            return;
        }
        if (name == null) {
            this.partElement.removeBinding();
            this.element().property(JWSOperationParameter.PROP_NAME).refresh();
            return;
        }
        List<IOperationParameter> bindings = this.partElement.getBindingsElements();
        IOperationParameter param = null;
        if (bindings.isEmpty()) {
            param = this.partElement.createNewBindings();
            param.attach((Listener)new FilteredListener<PropertyContentEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleTypedEvent(PropertyContentEvent event) {
                    JWSOperationParameterResource jWSOperationParameterResource = JWSOperationParameterResource.this;
                    synchronized (jWSOperationParameterResource) {
                        if (!JWSOperationParameterResource.this.rebroadcast.booleanValue()) {
                            return;
                        }
                    }
                    JWSOperationParameterResource.this.element().property(JWSOperationParameter.PROP_NAME).refresh();
                }
            });
        } else {
            param = bindings.get(0);
        }
        assert (param != null);
        IWsdlMessagePart part = this.partElement.getWsdlModelElement();
        IWsdlMessage message = (IWsdlMessage)part.nearest(IWsdlMessage.class);
        param.setMessageName(message.getMessageName().text());
        param.setPartName(part.getPartName().text());
        this.setRebroadcastEnabled(false);
        param.setName(name);
        String elementName = this.getChildElementName(param);
        if (elementName != null) {
            param.setType(elementName);
        }
        this.setRebroadcastEnabled(true);
    }

    private String findAndDefine(Element bindingsRoot, String attributeName, String searchAttributeName) {
        String attributeValue = bindingsRoot.getAttribute(attributeName);
        if (attributeValue == null) {
            Element initial;
            XmlResource xmlResource = (XmlResource)this.schemaElement.resource();
            XmlElement xml = xmlResource.getXmlElement();
            Node node = initial = xml.getDomNode();
            while (node != null && node.getNodeType() != 9 && !node.getLocalName().equals("schema")) {
                node = node.getParentNode();
            }
            assert (node != null);
            Element schemaRoot = null;
            Element root = null;
            if (node.getNodeType() == 1) {
                schemaRoot = node;
                root = schemaRoot.getOwnerDocument().getDocumentElement();
            } else if (node.getNodeType() == 9) {
                root = ((Document)node).getDocumentElement();
            }
            attributeValue = initial.getAttribute(searchAttributeName);
            if (schemaRoot != null && (attributeValue == null || attributeValue.length() == 0)) {
                attributeValue = schemaRoot.getAttribute(searchAttributeName);
            }
            if (attributeValue == null || attributeValue.length() == 0) {
                attributeValue = root.getAttribute(searchAttributeName);
            }
            if (attributeValue != null && attributeValue.length() > 0) {
                bindingsRoot.setAttribute(attributeName, attributeValue);
            }
        }
        return attributeValue;
    }

    public String isIn() {
        boolean isInput = this.wsdlParameter instanceof IWsdlOperationParameterInput;
        return Boolean.toString(isInput);
    }

    public String isOut() {
        boolean isOutput = this.wsdlParameter instanceof IWsdlOperationParameterOutput;
        return Boolean.toString(isOutput);
    }

    public String getMessageName() {
        String value = null;
        IWsdlMessagePart messagePart = this.partElement.getWsdlModelElement();
        if (messagePart != null) {
            IWsdlMessage message = (IWsdlMessage)messagePart.nearest(IWsdlMessage.class);
            if (message != null) {
                value = message.getMessageName().text();
            }
        } else {
            List<IOperationParameter> bindingParameters = this.partElement.getBindingsElements();
            for (IOperationParameter param : bindingParameters) {
                value = param.getMessageName().text();
                if (value != null) break;
            }
        }
        return value;
    }

    public String getPartName() {
        return this.partElement.getKeyValue();
    }

    public String getElementName() {
        String elementName = null;
        if (this.schemaElement != null && (elementName = this.schemaElement.getElementName().text()) == null) {
            elementName = this.schemaElement.getRefName().text();
        }
        return elementName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRebroadcastEnabled(boolean enabled) {
        JWSOperationParameterResource jWSOperationParameterResource = this;
        synchronized (jWSOperationParameterResource) {
            this.rebroadcast = enabled;
        }
    }

    private String getChildElementName(IOperationParameter param) {
        if (this.schemaElement != null) {
            String prefix = this.schemaElement.getTypeNamespacePrefix().text();
            String namespaceAttributeName = "xmlns:" + prefix;
            XmlResource xmlResource = (XmlResource)param.resource();
            XmlElement xml = xmlResource.getXmlElement();
            Element bindingsRoot = xml.getDomNode().getOwnerDocument().getDocumentElement();
            this.findAndDefine(bindingsRoot, namespaceAttributeName, namespaceAttributeName);
            String targetNamespace = this.findAndDefine(bindingsRoot, "xmlns:tns", "targetNamespace");
            String elementName = this.schemaElement.getElementName().text();
            if (targetNamespace != null && targetNamespace.length() > 0) {
                elementName = "tns:" + elementName;
            }
            return elementName;
        }
        return null;
    }
}

