/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.webservices.model.bindings.IOperationParameter;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationParameterResource;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationResource;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaComplexType;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaElement;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaSimpleType;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaType;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessage;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessagePart;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperation;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationParameter;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Resource;

public final class JWSOperationParameterListController
extends LayeredListPropertyBinding {
    private final JWSOperation operation;
    private final Resource resource;
    private Map<String, JWSOperationParameterResource> map = new HashMap<String, JWSOperationParameterResource>();

    public JWSOperationParameterListController(JWSOperation operation, Resource resource) {
        this.operation = operation;
        this.resource = resource;
    }

    protected List<?> readUnderlyingList() {
        Map<String, JWSOperationParameterResource> foundParameters = null;
        foundParameters = (Boolean)this.operation.isWrapperStyle().content(true) != false ? this.refreshWrapperStyle() : this.refreshNonWrapperStyle();
        int outputCount = 0;
        int currentIndex = 0;
        int lastOutputIndex = -1;
        ArrayList<String> parameters = new ArrayList<String>();
        for (String key : foundParameters.keySet()) {
            JWSOperationParameterResource param = foundParameters.get(key);
            parameters.add(key);
            if (Boolean.parseBoolean(param.isOut())) {
                ++outputCount;
                lastOutputIndex = currentIndex;
            }
            ++currentIndex;
        }
        if (outputCount == 1) {
            String lastKey = (String)parameters.get(lastOutputIndex);
            foundParameters.remove(lastKey);
        }
        Iterator<String> keys = this.map.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            if (foundParameters.containsKey(key)) continue;
            keys.remove();
        }
        for (String key : foundParameters.keySet()) {
            if (this.map.containsKey(key)) continue;
            this.map.put(key, foundParameters.get(key));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.map.keySet());
        return list;
    }

    private Map<String, JWSOperationParameterResource> refreshWrapperStyle() {
        LinkedHashMap<String, JWSOperationParameterResource> found = new LinkedHashMap<String, JWSOperationParameterResource>();
        HashMap<String, JWSOperationParameterResource> foundParts = new HashMap<String, JWSOperationParameterResource>();
        HashMap<String, JWSOperationParameterResource> foundElements = new HashMap<String, JWSOperationParameterResource>();
        HashMap<String, String> partNameToElementName = new HashMap<String, String>();
        IWsdlOperation wsdlOperation = ((JWSOperationResource)this.operation.resource()).operationElement.getWsdlModelElement();
        if (wsdlOperation != null) {
            IWsdlModel wsdlModel = (IWsdlModel)wsdlOperation.nearest(IWsdlModel.class);
            for (IWsdlOperationParameter wsdlParameter : wsdlOperation.getOperationParams()) {
                String messageName = wsdlParameter.getMessageName().text();
                String wsdlParameterName = wsdlParameter.getName().text();
                if (messageName == null) {
                    System.err.println("null messageName for param " + wsdlParameterName);
                    return found;
                }
                IWsdlMessage message = wsdlModel.findMessage(messageName);
                if (message == null) {
                    System.err.println("unable to find message for " + wsdlParameterName);
                    break;
                }
                ElementList<IWsdlMessagePart> parts = message.getMessageParts();
                for (IWsdlMessagePart part : parts) {
                    String partElementName = part.getElementName().text();
                    String partName = part.getPartName().text();
                    String foundKey = String.valueOf(messageName) + ':' + partName;
                    ISchemaType type = null;
                    ISchemaElement schemaElement = wsdlModel.findElement(partElementName);
                    if (schemaElement != null) {
                        String typeName = schemaElement.getTypeName().text();
                        if (typeName != null) {
                            type = wsdlModel.findType(typeName);
                        } else {
                            type = (ISchemaType)schemaElement.getComplexType().content();
                            if (type == null) {
                                type = (ISchemaType)schemaElement.getSimpleType().content();
                            }
                        }
                    }
                    if (type instanceof ISchemaSimpleType) {
                        JWSOperationParameterResource jwsParameter = new JWSOperationParameterResource(this.operation, this.operation.resource());
                        found.put(foundKey, jwsParameter);
                        foundParts.put(foundKey, jwsParameter);
                        jwsParameter.partElement.setWsdlModelElement(part);
                        jwsParameter.setSchemaElement(schemaElement);
                        jwsParameter.setWsdlParameter(wsdlParameter);
                        continue;
                    }
                    if (!(type instanceof ISchemaComplexType)) continue;
                    ElementList<ISchemaElement> elements = ((ISchemaComplexType)type).getSequenceElements();
                    for (ISchemaElement subElement : elements) {
                        String name = subElement.getElementName().text();
                        String ref = subElement.getRefName().text();
                        if (ref != null && ref.length() > 0) {
                            name = ref;
                        }
                        JWSOperationParameterResource jwsOpParamResource = new JWSOperationParameterResource(this.operation, this.operation.resource());
                        found.put(String.valueOf(foundKey) + ':' + name, jwsOpParamResource);
                        foundElements.put(name, jwsOpParamResource);
                        partNameToElementName.put(String.valueOf(messageName) + ':' + partName, name);
                        jwsOpParamResource.partElement.setWsdlModelElement(part);
                        jwsOpParamResource.setSchemaElement(subElement);
                        jwsOpParamResource.setWsdlParameter(wsdlParameter);
                    }
                }
            }
        }
        List<IPortTypeOperation> operationBindings = ((JWSOperationResource)this.operation.resource()).operationElement.getBindingsElements();
        for (IPortTypeOperation portTypeOperation : operationBindings) {
            ElementList<IOperationParameter> operationParameters = portTypeOperation.getParameters();
            for (IOperationParameter operationParameter : operationParameters) {
                String elementName;
                String partName = operationParameter.getPartName().text();
                String messageName = operationParameter.getMessageName().text();
                String foundKey = String.valueOf(messageName) + ':' + partName;
                JWSOperationParameterResource jwsParameter = (JWSOperationParameterResource)((Object)foundParts.get(partName));
                if (jwsParameter == null && (jwsParameter = (JWSOperationParameterResource)((Object)foundElements.get(elementName = operationParameter.getTypeName().text()))) != null && !ObjectUtil.equal((Object)partName, (Object)jwsParameter.getPartName())) {
                    jwsParameter = null;
                }
                if (jwsParameter != null) continue;
                jwsParameter = new JWSOperationParameterResource(this.operation, this.resource);
                found.put(foundKey, jwsParameter);
                foundParts.put(foundKey, jwsParameter);
            }
        }
        return found;
    }

    private Map<String, JWSOperationParameterResource> refreshNonWrapperStyle() {
        LinkedHashMap<String, JWSOperationParameterResource> found = new LinkedHashMap<String, JWSOperationParameterResource>();
        IWsdlOperation wsdlOperation = ((JWSOperationResource)this.operation.resource()).operationElement.getWsdlModelElement();
        if (wsdlOperation != null) {
            IWsdlModel wsdlModel = (IWsdlModel)wsdlOperation.nearest(IWsdlModel.class);
            for (IWsdlOperationParameter wsdlParameter : wsdlOperation.getOperationParams()) {
                String messageName = wsdlParameter.getMessageName().text();
                String wsdlParameterName = wsdlParameter.getName().text();
                if (messageName == null) {
                    System.err.println("null messageName for param " + wsdlParameterName);
                    return found;
                }
                IWsdlMessage message = wsdlModel.findMessage(messageName);
                if (message == null) {
                    System.err.println("unable to find message for " + wsdlParameterName);
                    break;
                }
                ElementList<IWsdlMessagePart> parts = message.getMessageParts();
                for (IWsdlMessagePart part : parts) {
                    String partName = part.getPartName().text();
                    JWSOperationParameterResource jwsParameter = new JWSOperationParameterResource(this.operation, this.resource);
                    found.put(String.valueOf(messageName) + ':' + partName, jwsParameter);
                    jwsParameter.partElement.setWsdlModelElement(part);
                    String partElementName = part.getElementName().text();
                    jwsParameter.setSchemaElement(wsdlModel.findElement(partElementName));
                    jwsParameter.setWsdlParameter(wsdlParameter);
                }
            }
        }
        List<IPortTypeOperation> operationBindings = ((JWSOperationResource)this.operation.resource()).operationElement.getBindingsElements();
        for (IPortTypeOperation portTypeOperation : operationBindings) {
            ElementList<IOperationParameter> operationParameters = portTypeOperation.getParameters();
            for (IOperationParameter operationParameter : operationParameters) {
                String messageName = operationParameter.getMessageName().text();
                String partName = operationParameter.getPartName().text();
                String foundKey = String.valueOf(messageName) + ':' + partName;
                JWSOperationParameterResource jwsParameter = (JWSOperationParameterResource)((Object)found.get(foundKey));
                if (jwsParameter != null) continue;
                jwsParameter = new JWSOperationParameterResource(this.operation, this.resource);
                found.put(foundKey, jwsParameter);
            }
        }
        return found;
    }

    public ElementType type(Resource resource) {
        return JWSOperationParameter.TYPE;
    }

    protected Resource resource(Object obj) {
        return this.map.get(obj);
    }
}

