/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import oracle.eclipse.tools.webservices.model.BaseResource;
import oracle.eclipse.tools.webservices.model.bindings.IHandler;
import oracle.eclipse.tools.webservices.model.bindings.IInitParam;
import oracle.eclipse.tools.webservices.model.bindings.ISillyString;
import oracle.eclipse.tools.webservices.model.jws.JWSHandler;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerParameter;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerType;
import oracle.eclipse.tools.webservices.model.jws.JWSString;
import oracle.eclipse.tools.webservices.model.jws.LayeredListPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSHandlerParameterResource;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSStringResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;

public class JWSHandlerResource
extends BaseResource<IHandler> {
    private ValuePropertyMapper<Value<String>> name;
    private ValuePropertyMapper<Value<String>> className;
    private ValuePropertyMapper<Value<String>> description;
    private LayeredListPropertyMapper<IInitParam, JWSHandlerParameter> parameters;
    private LayeredListPropertyMapper<ISillyString, JWSString> soapRoles;
    private LayeredListPropertyMapper<ISillyString, JWSString> soapHeaders;
    private JWSHandlerType handlerType = JWSHandlerType.SOAP;

    public JWSHandlerResource(Resource resource, IHandler handler) {
        super(resource, handler);
    }

    public void init(Element element) {
        super.init(element);
        this.parameters = new LayeredListPropertyMapper<IInitParam, JWSHandlerParameter>(IHandler.PROP_INIT_PARAMETERS, (Element)this.getBase(), JWSHandler.PROP_PARAMETERS, this.element(), new LayeredListPropertyMapper.IListResourceFactory<IInitParam, JWSHandlerParameter>(){

            @Override
            public Resource createNewResource(ElementType type, IInitParam fromElement, ElementList<JWSHandlerParameter> parent) {
                return new JWSHandlerParameterResource((Resource)JWSHandlerResource.this, fromElement);
            }

            @Override
            public ElementType type(Resource resource) {
                return JWSHandlerParameter.TYPE;
            }

            @Override
            public void setUnderlyingElementForType(ElementType type, IInitParam fromElement) {
            }
        });
        this.name = new ValuePropertyMapper(IHandler.PROP_NAME, (Element)this.getBase(), JWSHandler.PROP_NAME, this.element());
        this.className = new ValuePropertyMapper(IHandler.PROP_CLASS_NAME, (Element)this.getBase(), JWSHandler.PROP_CLASS_NAME, this.element());
        this.description = new ValuePropertyMapper(IHandler.PROP_DESCRIPTION, (Element)this.getBase(), JWSHandler.PROP_DESCRIPTION, this.element());
        this.soapRoles = new LayeredListPropertyMapper<ISillyString, JWSString>(IHandler.PROP_SOAP_ROLES, (Element)this.getBase(), JWSHandler.PROP_SOAP_ROLES, this.element(), new LayeredListPropertyMapper.IListResourceFactory<ISillyString, JWSString>(){

            @Override
            public Resource createNewResource(ElementType type, ISillyString fromElement, ElementList<JWSString> parent) {
                return new JWSStringResource((Resource)JWSHandlerResource.this, fromElement);
            }

            @Override
            public ElementType type(Resource resource) {
                return JWSString.TYPE;
            }

            @Override
            public void setUnderlyingElementForType(ElementType type, ISillyString fromElement) {
            }
        });
        this.soapHeaders = new LayeredListPropertyMapper<ISillyString, JWSString>(IHandler.PROP_SOAP_HEADERS, (Element)this.getBase(), JWSHandler.PROP_SOAP_HEADERS, this.element(), new LayeredListPropertyMapper.IListResourceFactory<ISillyString, JWSString>(){

            @Override
            public Resource createNewResource(ElementType type, ISillyString fromElement, ElementList<JWSString> parent) {
                return new JWSStringResource((Resource)JWSHandlerResource.this, fromElement);
            }

            @Override
            public ElementType type(Resource resource) {
                return JWSString.TYPE;
            }

            @Override
            public void setUnderlyingElementForType(ElementType type, ISillyString fromElement) {
            }
        });
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSHandler.PROP_PARAMETERS) {
            return this.parameters;
        }
        if (p == JWSHandler.PROP_NAME) {
            return this.createValuePropertyMapperBinding(this.name);
        }
        if (p == JWSHandler.PROP_CLASS_NAME) {
            return this.createValuePropertyMapperBinding(this.className);
        }
        if (p == JWSHandler.PROP_DESCRIPTION) {
            return this.createValuePropertyMapperBinding(this.description);
        }
        if (p == JWSHandler.PROP_SOAP_ROLES) {
            return this.soapRoles;
        }
        if (p == JWSHandler.PROP_SOAP_HEADERS) {
            return this.soapHeaders;
        }
        if (p == JWSHandler.PROP_HANDLER_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSHandlerResource.this.getHandlerType().toString();
                }

                public void write(String value) {
                    if (JWSHandlerType.SOAP.toString().equalsIgnoreCase(value)) {
                        JWSHandlerResource.this.setHandlerType(JWSHandlerType.SOAP);
                    }
                    if (JWSHandlerType.LOGICAL.toString().equalsIgnoreCase(value)) {
                        JWSHandlerResource.this.setHandlerType(JWSHandlerType.LOGICAL);
                    }
                }
            };
        }
        return null;
    }

    protected PropertyBinding createValuePropertyMapperBinding(final ValuePropertyMapper mapper) {
        return new ValuePropertyBinding(){

            public String read() {
                return mapper.read();
            }

            public void write(String value) {
                mapper.setValue(value);
            }
        };
    }

    public String getClassName() {
        return this.className.read();
    }

    public void setClassName(String name) {
        this.className.setValue(name);
    }

    public String getName() {
        return this.name.read();
    }

    public void setName(String name) {
        this.name.setValue(name);
    }

    public String getDescription() {
        return this.description.read();
    }

    public void setDescription(String description) {
        this.description.setValue(description);
    }

    public JWSHandlerType getHandlerType() {
        return this.handlerType;
    }

    public void setHandlerType(JWSHandlerType handlerType) {
        this.handlerType = handlerType;
    }
}

