/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import oracle.eclipse.tools.webservices.model.BaseResource;
import oracle.eclipse.tools.webservices.model.bindings.IHandler;
import oracle.eclipse.tools.webservices.model.bindings.IHandlerChain;
import oracle.eclipse.tools.webservices.model.jws.JWSHandler;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerChain;
import oracle.eclipse.tools.webservices.model.jws.LayeredListPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSHandlerResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;

public final class JWSHandlerChainResource
extends BaseResource<IHandlerChain> {
    private LayeredListPropertyMapper<IHandler, JWSHandler> handlers;
    private ValuePropertyMapper<Value<String>> serviceName;
    private ValuePropertyMapper<Value<String>> portName;
    private ValuePropertyMapper<Value<String>> protocol;

    public JWSHandlerChainResource(Resource resource, IHandlerChain handlerChain) {
        super(resource, handlerChain);
    }

    public void init(Element element) {
        super.init(element);
        this.initBindingObjects();
    }

    void initBindingObjects() {
        this.handlers = new LayeredListPropertyMapper<IHandler, JWSHandler>(IHandlerChain.PROP_HANDLERS, (Element)this.getBase(), JWSHandlerChain.PROP_HANDLERS, this.element(), new LayeredListPropertyMapper.IListResourceFactory<IHandler, JWSHandler>(){

            @Override
            public Resource createNewResource(ElementType type, IHandler fromElement, ElementList<JWSHandler> parent) {
                return new JWSHandlerResource((Resource)JWSHandlerChainResource.this, fromElement);
            }

            @Override
            public ElementType type(Resource resource) {
                return JWSHandler.TYPE;
            }

            @Override
            public void setUnderlyingElementForType(ElementType type, IHandler fromElement) {
            }
        });
        this.serviceName = new ValuePropertyMapper(IHandlerChain.PROP_SERVICE_NAME, (Element)this.getBase(), JWSHandlerChain.PROP_SERVICE_NAME, this.element());
        this.portName = new ValuePropertyMapper(IHandlerChain.PROP_PORT_NAME, (Element)this.getBase(), JWSHandlerChain.PROP_PORT_NAME, this.element());
        this.protocol = new ValuePropertyMapper(IHandlerChain.PROP_PROTOCOL, (Element)this.getBase(), JWSHandlerChain.PROP_PROTOCOL, this.element());
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSHandlerChain.PROP_HANDLERS) {
            return this.handlers;
        }
        if (p == JWSHandlerChain.PROP_SERVICE_NAME) {
            return this.createValuePropertyMapperBinding(this.serviceName);
        }
        if (p == JWSHandlerChain.PROP_PORT_NAME) {
            return this.createValuePropertyMapperBinding(this.portName);
        }
        if (p == JWSHandlerChain.PROP_PROTOCOL) {
            return this.createValuePropertyMapperBinding(this.protocol);
        }
        if (p == JWSHandlerChain.PROP_CONFIGURATION_URI) {
            return this.getConfigurationUriBinding();
        }
        return null;
    }

    protected PropertyBinding createValuePropertyMapperBinding(final ValuePropertyMapper mapper) {
        return new ValuePropertyBinding(){

            public String read() {
                return mapper.read();
            }

            public void write(String value) {
                mapper.setValue(value);
            }
        };
    }

    public String getServiceName() {
        return this.serviceName.read();
    }

    public void setServiceName(String name) {
        this.serviceName.setValue(name);
    }

    public String getPortName() {
        return this.portName.read();
    }

    public void setPortName(String name) {
        this.portName.setValue(name);
    }

    public String getProtocol() {
        return this.protocol.read();
    }

    public void setProtocol(String protocol) {
        this.protocol.setValue(protocol);
    }

    public void setConfigurationUri(String uri) {
    }

    public PropertyBinding getConfigurationUriBinding() {
        return new ValuePropertyBinding(){

            public String read() {
                return null;
            }

            public void write(String value) {
            }
        };
    }
}

