/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.webservices.model.wsdl.ISchema;
import oracle.eclipse.tools.webservices.util.NameConverter;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class JAXBTypeMapper
extends XmlValueBindingImpl {
    private static final Map<String, String> typeMap = new HashMap<String, String>();

    static {
        typeMap.put("string", "java.lang.String");
        typeMap.put("integer", "java.math.BigInteger");
        typeMap.put("int", "int");
        typeMap.put("long", "long");
        typeMap.put("short", "short");
        typeMap.put("decimal", "java.math.BigDecimal");
        typeMap.put("float", "float");
        typeMap.put("double", "double");
        typeMap.put("boolean", "boolean");
        typeMap.put("byte", "byte");
        typeMap.put("QName", "javax.xml.namespace.QName 1");
        typeMap.put("dateTime", "javax.xml.datatype.XMLGregorianCalendar 1");
        typeMap.put("base64Binary", "byte[]");
        typeMap.put("hexBinary", "byte[]");
        typeMap.put("unsignedInt", "long");
        typeMap.put("unsignedShort", "int");
        typeMap.put("unsignedByte", "short");
        typeMap.put("time", "javax.xml.datatype.XMLGregorianCalendar 1.");
        typeMap.put("date", "javax.xml.datatype.XMLGregorianCalendar 1.");
        typeMap.put("g*", "javax.xml.datatype.XMLGregorianCalendar 1.");
        typeMap.put("duration", "javax.xml.datatype.Duration");
        typeMap.put("NOTATION", "javax.xml.namespace.QName");
    }

    protected String getJavaTypeName(String xmlName) {
        if (xmlName == null) {
            return "";
        }
        if (xmlName.length() == 0) {
            return xmlName;
        }
        return String.valueOf(xmlName.substring(0, 1).toUpperCase()) + xmlName.substring(1);
    }

    protected String getNamespaceURI(ISchema schema, String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return schema.getTargetNamespace().text();
        }
        Element element = ((XmlResource)schema.adapt(XmlResource.class)).getXmlElement().getDomNode();
        String namespace = this.findNamespace(element.getAttributes(), prefix);
        if (namespace != null) {
            return namespace;
        }
        Element root = element.getOwnerDocument().getDocumentElement();
        return this.findNamespace(root.getAttributes(), prefix);
    }

    private String findNamespace(NamedNodeMap attrs, String prefix) {
        int i = 0;
        while (i < attrs.getLength()) {
            String[] parts;
            Attr attr;
            String attrName;
            Node n = attrs.item(i);
            if (n instanceof Attr && (attrName = (attr = (Attr)n).getName()).startsWith("xmlns:") && prefix.equals((parts = attrName.split(":"))[1])) {
                return attr.getValue();
            }
            ++i;
        }
        return null;
    }

    protected String getTypePackageName(ISchema schema, String prefix) {
        assert (schema != null);
        String namespace = this.getNamespaceURI(schema, prefix);
        return namespace == null ? null : NameConverter.toPackageName(namespace);
    }

    public void write(String value) {
        throw new IllegalAccessError("the schema model is read only.");
    }

    protected String mapNameAndNamespaceToType(String baseName, String prefix, ISchema schema) {
        String namespace = this.getNamespaceURI(schema, prefix);
        String typeName = this.mapBaseToType(baseName, namespace);
        if (typeName != null) {
            return typeName;
        }
        typeName = this.getJavaTypeName(baseName);
        return namespace == null ? typeName : String.valueOf(NameConverter.toPackageName(namespace)) + '.' + typeName;
    }

    protected String mapBaseToType(String name, String namespace) {
        if (!"http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            return null;
        }
        String type = typeMap.get(name);
        if (type != null) {
            return type;
        }
        return Object.class.getCanonicalName();
    }
}

