/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IDefinitions;
import oracle.eclipse.tools.webservices.model.bindings.IHandler;
import oracle.eclipse.tools.webservices.model.bindings.IHandlerChain;
import oracle.eclipse.tools.webservices.model.bindings.IInitParam;
import oracle.eclipse.tools.webservices.model.bindings.ISillyString;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerChain;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSHandlerChainResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Resource;

public final class HandlerChainListController
extends LayeredListPropertyBinding {
    private final JWSModelGroup group;

    public HandlerChainListController(JWSModelGroup modelGroup) {
        this.group = modelGroup;
    }

    protected List<IHandlerChain> readUnderlyingList() {
        ArrayList<IHandlerChain> found = new ArrayList<IHandlerChain>();
        IBindingsSet bindingsSet = (IBindingsSet)this.group.getBindingsSet().content();
        ElementList<IDefinitions> definitionsList = bindingsSet.getDefinitions();
        for (IDefinitions def : definitionsList) {
            ElementList<IHandlerChain> handlerChains = def.getHandlerChains();
            for (IHandlerChain handlerChain : handlerChains) {
                found.add(handlerChain);
            }
        }
        return found;
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        IHandlerChain obj = this.insertUnderlyingObject(type);
        return obj;
    }

    public IHandlerChain insertUnderlyingObject(ElementType type) {
        ElementList<IDefinitions> definitionsList = ((IBindingsSet)this.group.getBindingsSet().content()).getDefinitions();
        Iterator iterator = definitionsList.iterator();
        if (iterator.hasNext()) {
            IDefinitions def = (IDefinitions)iterator.next();
            ElementList<IHandlerChain> handlerChains = def.getHandlerChains();
            return (IHandlerChain)handlerChains.insert();
        }
        return null;
    }

    public void move(Resource resource, int position) {
        List list = this.read();
        int size = list.size();
        if (position < 0 || position > size) {
            throw new IllegalArgumentException();
        }
        int oldPosition = list.indexOf(resource);
        if (position < oldPosition) {
            int diff = oldPosition - position;
            if (diff > 1) {
                int i = oldPosition;
                while (i >= position) {
                    this.moveUp(this.read(), resource);
                    --i;
                }
            } else {
                this.moveUp(list, resource);
            }
        } else {
            int diff = position - oldPosition;
            if (diff > 1) {
                int i = oldPosition;
                while (i <= position) {
                    this.moveDown(this.read(), resource);
                    ++i;
                }
            } else {
                this.moveDown(list, resource);
            }
        }
    }

    private void moveUp(List<Resource> list, Resource resource) {
        int index = list.indexOf(resource);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        if (index > 0) {
            Resource previous = list.get(index - 1);
            this.swap(resource, previous);
        }
    }

    private void moveDown(List<Resource> list, Resource resource) {
        int index = list.indexOf(resource);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        if (index < list.size() - 1) {
            Resource next = list.get(index + 1);
            this.swap(resource, next);
        }
    }

    private void swap(Resource chainA, Resource chainB) {
        IHandlerChain a = (IHandlerChain)((JWSHandlerChainResource)chainA).getBase();
        IHandlerChain b = (IHandlerChain)((JWSHandlerChainResource)chainB).getBase();
        IBindingsSet bindingsSet = (IBindingsSet)this.group.getBindingsSet().content();
        ElementList<IDefinitions> definitionsList = bindingsSet.getDefinitions();
        ElementList<IHandlerChain> handlerChainsContainingA = null;
        ElementList<IHandlerChain> handlerChainsContainingB = null;
        for (IDefinitions def : definitionsList) {
            ElementList<IHandlerChain> handlerChains = def.getHandlerChains();
            if (handlerChains.contains((Object)a)) {
                handlerChainsContainingA = handlerChains;
            }
            if (!handlerChains.contains((Object)b)) continue;
            handlerChainsContainingB = handlerChains;
        }
        if (handlerChainsContainingA != null && handlerChainsContainingB != null) {
            if (handlerChainsContainingA == handlerChainsContainingB) {
                handlerChainsContainingA.swap((Element)a, (Element)b);
            } else {
                int indexA = handlerChainsContainingA.indexOf((Object)a);
                int indexB = handlerChainsContainingB.indexOf((Object)b);
                ((JWSHandlerChainResource)chainB).setBase(this.copy(b, indexA, handlerChainsContainingA));
                ((JWSHandlerChainResource)chainA).setBase(this.copy(a, indexB, handlerChainsContainingB));
                handlerChainsContainingA.remove((Object)a);
                handlerChainsContainingB.remove((Object)b);
            }
        }
    }

    private IHandlerChain copy(IHandlerChain chain, int index, ElementList<IHandlerChain> handlerChains) {
        IHandlerChain newChain = (IHandlerChain)handlerChains.insert();
        newChain.setPortName(chain.getPortName().text(false));
        newChain.setProtocol(chain.getProtocol().text(false));
        newChain.setServiceName(chain.getServiceName().text(false));
        for (IHandler handler : chain.getHandlers()) {
            IHandler newHandler = (IHandler)newChain.getHandlers().insert();
            newHandler.setName(handler.getName().text(false));
            newHandler.setClassName(handler.getClassName().text(false));
            newHandler.setDescription(handler.getDescription().text(false));
            for (IInitParam initParameter : handler.getInitParameters()) {
                IInitParam newInitParameter = (IInitParam)newHandler.getInitParameters().insert();
                newInitParameter.setName(initParameter.getName().text(false));
                newInitParameter.setValue(initParameter.getValue().text(false));
            }
            for (ISillyString soapHeader : handler.getSoapHeaders()) {
                ISillyString newSoapHeader = (ISillyString)newHandler.getSoapHeaders().insert();
                newSoapHeader.setValue(soapHeader.getValue().text(false));
            }
            for (ISillyString soapRole : handler.getSoapRoles()) {
                ISillyString newSoapRole = (ISillyString)newHandler.getSoapRoles().insert();
                newSoapRole.setValue(soapRole.getValue().text(false));
            }
        }
        int newIndex = handlerChains.indexOf((Object)newChain);
        while (newIndex > index) {
            handlerChains.swap((Element)newChain, handlerChains.get(newIndex - 1));
            newIndex = handlerChains.indexOf((Object)newChain);
        }
        return newChain;
    }

    protected Resource resource(Object obj) {
        return new JWSHandlerChainResource(this.group.resource(), (IHandlerChain)obj);
    }

    public ElementType type(Resource resource) {
        return JWSHandlerChain.TYPE;
    }

    public void remove(Resource resource) {
        IHandlerChain handlerChain = (IHandlerChain)((JWSHandlerChainResource)resource).getBase();
        IBindingsSet bindingsSet = (IBindingsSet)this.group.getBindingsSet().content();
        ElementList<IDefinitions> definitionsList = bindingsSet.getDefinitions();
        for (IDefinitions def : definitionsList) {
            ElementList<IHandlerChain> handlerChains = def.getHandlerChains();
            if (!handlerChains.contains((Object)handlerChain)) continue;
            handlerChains.remove((Object)handlerChain);
            break;
        }
    }
}

