/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperationFault;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSFault;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsModelListController2;
import oracle.eclipse.tools.webservices.model.jws.internal.FaultResource;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationResource;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperation;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationFault;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

final class FaultListController
extends ListPropertyBinding {
    private final JWSOperation parent;
    private Map<String, FaultResource> current = new LinkedHashMap<String, FaultResource>();
    private final BindingsModelListController2<IWsdlOperation, IBindingsSet, FaultResource, IWsdlOperationFault, IPortTypeOperationFault> operationFaultList = new BindingsModelListController2<IWsdlOperation, IBindingsSet, FaultResource, IWsdlOperationFault, IPortTypeOperationFault>(IPortTypeOperationFault.PROP_FAULT_NAME, IWsdlOperationFault.PROP_FAULT_NAME, IBindingsSet.PROP_FAULTS, IWsdlOperation.PROP_OPERATION_FAULTS){

        IWsdlOperation[] getWsdlListParents() {
            return new IWsdlOperation[]{((JWSOperationResource)((FaultListController)FaultListController.this).parent.resource()).operationElement.getWsdlModelElement()};
        }

        IBindingsSet[] getBindingListParents() {
            return new IBindingsSet[]{(IBindingsSet)((JWSModelGroup)FaultListController.this.parent.root()).getBindingsSet().content()};
        }

        @Override
        FaultResource create() {
            return new FaultResource(FaultListController.this.parent.resource(), FaultListController.this.parent);
        }

        @Override
        JWSModelElement<FaultResource, IWsdlOperationFault, IPortTypeOperationFault> adaptToJWSModelElement(FaultResource model) {
            return model.faultElement;
        }

        @Override
        protected boolean filterBindingsElement(IPortTypeOperationFault bindings) {
            JWSModel jwsModel = (JWSModel)FaultListController.this.parent.nearest(JWSModel.class);
            return ObjectUtil.equals((Object)jwsModel.getServiceName().text(), (Object)bindings.getPortTypeName().text()) && ObjectUtil.equal((Object)FaultListController.this.parent.getOperationName().text(), (Object)bindings.getOperationName().text());
        }

        @Override
        protected boolean filterInvalidElement(IInvalid invalid) {
            JWSModel jwsModel = (JWSModel)FaultListController.this.parent.nearest(JWSModel.class);
            XmlResource xmlResource = (XmlResource)invalid.resource();
            XmlElement element = xmlResource.getXmlElement();
            if (ObjectUtil.equal((Object)jwsModel.getServiceName().text(), (Object)NodeNameBinding.Patterns.portType.getValue(element)) && ObjectUtil.equal((Object)FaultListController.this.parent.getOperationName().text(), (Object)NodeNameBinding.Patterns.portTypeOperation.getValue(element))) {
                return super.filterInvalidElement(invalid);
            }
            return false;
        }
    };

    FaultListController(JWSOperation operation) {
        this.parent = operation;
    }

    public List<Resource> read() {
        if (this.current.isEmpty()) {
            LinkedHashMap updates = new LinkedHashMap();
            this.operationFaultList.refresh(this.current, updates);
            this.current.clear();
            for (String key : updates.keySet()) {
                this.current.put(key, (FaultResource)((Object)updates.get(key)));
            }
        }
        return new ArrayList<Resource>(this.current.values());
    }

    public ElementType type(Resource resource) {
        return JWSFault.TYPE;
    }
}

