/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.Map;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsElement;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.xml.XmlResource;

abstract class BindingsModelListController2<PARENT_WSDL_MODEL_TYPE extends Element, PARENT_BINDINGS_MODEL_TYPE extends Element, JWS_MODEL_TYPE extends Resource, WSDL_MODEL_TYPE extends Element, BINDINGS_MODEL_TYPE extends IBindingsElement> {
    private final ListProperty bindingsListProperty;
    private final ListProperty wsdlListProperty;
    private final ValueProperty bindingsKeyProperty;
    private final ValueProperty wsdlKeyProperty;
    private final NodeNameBinding.Patterns pattern;

    protected BindingsModelListController2(ValueProperty bindingsKey, ValueProperty wsdlKey, ListProperty bindings, ListProperty wsdl) {
        this(bindingsKey, wsdlKey, bindings, wsdl, null);
    }

    protected BindingsModelListController2(ValueProperty bindingsKey, ValueProperty wsdlKey, ListProperty bindings, ListProperty wsdl, NodeNameBinding.Patterns invalidPattern) {
        this.bindingsListProperty = bindings;
        this.wsdlListProperty = wsdl;
        this.bindingsKeyProperty = bindingsKey;
        this.wsdlKeyProperty = wsdlKey;
        this.pattern = invalidPattern;
    }

    public final void refresh(Map<String, JWS_MODEL_TYPE> previous, Map<String, JWS_MODEL_TYPE> current) {
        Element[] parentBindingsElements;
        Object model;
        String keyValue;
        int n;
        Element[] elementArray;
        for (Resource model2 : previous.values()) {
            JWSModelElement<Resource, Object, BINDINGS_MODEL_TYPE> modelElement = this.adaptToJWSModelElement(model2);
            modelElement.setWsdlModelElement(null);
        }
        if (this.wsdlListProperty != null) {
            Element[] parentWsdlElements;
            elementArray = parentWsdlElements = this.getWsdlListParents();
            n = parentWsdlElements.length;
            int modelElement = 0;
            while (modelElement < n) {
                Element parentWsdlElement = elementArray[modelElement];
                if (parentWsdlElement != null) {
                    assert (this.wsdlListProperty.getModelElementType() == parentWsdlElement.type());
                    ElementList wsdlElementList = parentWsdlElement.property(this.wsdlListProperty);
                    for (Element wsdlElement : wsdlElementList) {
                        assert (this.wsdlKeyProperty.getModelElementType() == wsdlElement.type());
                        if (!this.filterWsdlElement(wsdlElement)) continue;
                        keyValue = JWSModelElement.getString(this.wsdlKeyProperty, wsdlElement);
                        model = (Resource)previous.get(keyValue);
                        if (model == null) {
                            model = (Resource)current.get(keyValue);
                            if (model == null) {
                                model = this.create();
                                current.put(keyValue, model);
                            }
                        } else {
                            current.put(keyValue, model);
                        }
                        assert (model != null);
                        this.adaptToJWSModelElement(model).setWsdlModelElement(wsdlElement);
                    }
                }
                ++modelElement;
            }
        }
        if (this.bindingsListProperty != null) {
            parentBindingsElements = this.getBindingListParents();
            elementArray = parentBindingsElements;
            n = parentBindingsElements.length;
            int modelElement = 0;
            while (modelElement < n) {
                Element parentBindings = elementArray[modelElement];
                if (parentBindings != null) {
                    assert (this.bindingsListProperty.getModelElementType() == parentBindings.type());
                    ElementList bindingsElementList = parentBindings.property(this.bindingsListProperty);
                    for (IBindingsElement bindingsElement : bindingsElementList) {
                        assert (this.bindingsKeyProperty.getModelElementType() == bindingsElement.type());
                        if (!this.filterBindingsElement(bindingsElement)) continue;
                        keyValue = JWSModelElement.getString(this.bindingsKeyProperty, bindingsElement);
                        model = (Resource)previous.get(keyValue);
                        if (model == null) {
                            model = (Resource)current.get(keyValue);
                            if (model == null) {
                                model = this.create();
                                current.put(keyValue, model);
                            }
                        } else {
                            current.put(keyValue, model);
                        }
                        assert (model != null);
                    }
                }
                ++modelElement;
            }
        }
        if (this.pattern != null) {
            Element imodel;
            parentBindingsElements = this.getBindingListParents();
            IBindingsSet bindingsSet = null;
            if (parentBindingsElements.length > 0 && (imodel = parentBindingsElements[0]) instanceof IBindingsSet) {
                bindingsSet = (IBindingsSet)imodel;
            }
            if (bindingsSet != null) {
                for (IInvalid invalid : bindingsSet.getInvalids()) {
                    if (!this.filterInvalidElement(invalid)) continue;
                    XmlResource resource = (XmlResource)invalid.resource();
                    String value = this.pattern.getValue(resource.getXmlElement());
                    Object model3 = (Resource)previous.get(value);
                    if (model3 == null) {
                        model3 = (Resource)current.get(value);
                        if (model3 == null) {
                            model3 = this.create();
                            current.put(value, model3);
                        }
                    } else {
                        current.put(value, model3);
                    }
                    assert (model3 != null);
                }
            }
        }
    }

    abstract JWS_MODEL_TYPE create();

    abstract PARENT_WSDL_MODEL_TYPE[] getWsdlListParents();

    abstract PARENT_BINDINGS_MODEL_TYPE[] getBindingListParents();

    abstract JWSModelElement<JWS_MODEL_TYPE, WSDL_MODEL_TYPE, BINDINGS_MODEL_TYPE> adaptToJWSModelElement(JWS_MODEL_TYPE var1);

    protected boolean filterWsdlElement(WSDL_MODEL_TYPE element) {
        return true;
    }

    protected boolean filterBindingsElement(BINDINGS_MODEL_TYPE element) {
        return true;
    }

    protected boolean filterInvalidElement(IInvalid invalid) {
        XmlResource xmlResource = (XmlResource)invalid.resource();
        return this.pattern.applies(xmlResource.getXmlElement());
    }
}

