/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;

abstract class AbstractJWSModelElement
extends Resource {
    private final List<JWSModelElement> modelElements = new ArrayList<JWSModelElement>();
    private static final Set<ValueProperty> keyProperties = new HashSet<ValueProperty>();
    private static final Set<ValueProperty> bindingsProperties = new HashSet<ValueProperty>();

    public AbstractJWSModelElement(Resource parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addKeyProperty(ValueProperty key, ListProperty ... properties) {
        Set<ValueProperty> set = keyProperties;
        synchronized (set) {
            if (!keyProperties.contains(key)) {
                keyProperties.add(key);
            }
        }
    }

    protected void addModelElement(JWSModelElement<?, ?, ?> element) {
        this.modelElements.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addModelElement(JWSModelElement<?, ?, ?> element, ValueProperty property) {
        this.addModelElement(element);
        Set<ValueProperty> set = bindingsProperties;
        synchronized (set) {
            if (!bindingsProperties.contains(element.bindingsKeyProperty)) {
                bindingsProperties.add(element.bindingsKeyProperty);
            }
        }
    }

    protected String getKeyValue() {
        String value = null;
        for (JWSModelElement modelElement : this.modelElements) {
            value = modelElement.getKeyValue();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Status validate() {
        Status status = Status.createOkStatus();
        if (!this.modelElements.isEmpty()) {
            JWSModelElement element = this.modelElements.get(0);
            status = element.validateWsdlElement();
            if (!status.ok()) {
                return status;
            }
            for (JWSModelElement modelElement : this.modelElements) {
                status = modelElement.validateInvalids();
                if (status.ok()) continue;
                return status;
            }
        }
        return status;
    }
}

