/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws;

import java.util.List;
import oracle.eclipse.tools.webservices.model.BaseResource;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Resource;

public class LayeredListPropertyMapper<FROM_ELEMENT extends Element, TO_ELEMENT extends Element>
extends LayeredListPropertyBinding {
    private final ModelPropertyMapper<ListProperty> mapper;
    private ElementList<TO_ELEMENT> toElementList;
    private IListResourceFactory<FROM_ELEMENT, TO_ELEMENT> factory;

    public LayeredListPropertyMapper(ListProperty fromProperty, Element fromModel, ListProperty toProperty, Element toModel, IListResourceFactory<FROM_ELEMENT, TO_ELEMENT> factory) {
        this.mapper = new ModelPropertyMapper<ListProperty>(fromProperty, fromModel, toProperty, toModel);
        this.factory = factory;
    }

    private ElementList<FROM_ELEMENT> getFromList() {
        return this.mapper.getFromModel().property(this.mapper.getFromProperty());
    }

    protected List<?> readUnderlyingList() {
        return this.getFromList();
    }

    protected Resource resource(Object obj) {
        return this.factory.createNewResource(null, (Element)obj, this.toElementList);
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        Object obj = this.insertUnderlyingObject(type);
        this.move(this.resource(obj), position);
        return obj;
    }

    private Object insertUnderlyingObject(ElementType type) {
        Element fromElement = this.getFromList().insert();
        this.factory.setUnderlyingElementForType(type, fromElement);
        return fromElement;
    }

    public ElementType type(Resource resource) {
        return this.factory.type(resource);
    }

    public void move(Resource resource, int position) {
        this.setRebroadcastEnabled(false);
        Element element = (Element)((BaseResource)resource).getBase();
        this.getFromList().move(element, position);
        this.setRebroadcastEnabled(true);
    }

    public void remove(Resource resource) {
        if (resource instanceof BaseResource && !this.getFromList().definition().isReadOnly()) {
            this.getFromList().remove(((BaseResource)resource).getBase());
        }
    }

    public void setRebroadcastEnabled(boolean enabled) {
        this.mapper.setRebroadcastEnabled(enabled);
    }

    public static interface IListResourceFactory<FROM_ELEMENT extends Element, TO_ELEMENT extends Element> {
        public Resource createNewResource(ElementType var1, FROM_ELEMENT var2, ElementList<TO_ELEMENT> var3);

        public ElementType type(Resource var1);

        public void setUnderlyingElementForType(ElementType var1, FROM_ELEMENT var2);
    }
}

