/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.bindings.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.webservices.model.bindings.IBinding;
import oracle.eclipse.tools.webservices.model.bindings.IBindingOperation;
import oracle.eclipse.tools.webservices.model.bindings.IOperationParameter;
import oracle.eclipse.tools.webservices.model.bindings.IPortType;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperationFault;
import oracle.eclipse.tools.webservices.model.bindings.IService;
import oracle.eclipse.tools.webservices.model.bindings.IServicePort;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class NodeNameBinding
extends XmlValueBindingImpl {
    private static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";

    public String read() {
        XmlElement xmlElement = this.xml(false);
        return Patterns.getValue(xmlElement, (ValueProperty)this.property().definition());
    }

    public void write(String value) {
        XmlElement e = this.xml(true);
        Patterns.setValue(e, (ValueProperty)this.property().definition(), value);
    }

    public static enum Patterns {
        definitions("definitions", true, new ValueProperty[0]),
        portType("definitions/portType\\[@name='([^']*)'\\]", IPortType.PROP_PORT_TYPE_NAME, IPortTypeOperation.PROP_PORT_TYPE_NAME, IPortTypeOperationFault.PROP_PORT_TYPE_NAME),
        portTypeOperation("definitions/portType\\[@name='[^']*'\\]/operation\\[@name='([^']*)'\\]", IPortTypeOperation.PROP_OPERATION_NAME, IPortTypeOperationFault.PROP_OPERATION_NAME),
        fault("definitions/portType\\[@name='[^']*'\\]/operation\\[@name='[^']*'\\]/fault\\[@name='([^']*)'\\]", IPortTypeOperationFault.PROP_FAULT_NAME),
        binding("definitions/binding\\[@name='([^']*)'\\]", IBinding.PROP_BINDING_NAME, IBindingOperation.PROP_BINDING_NAME),
        bindingOperation("definitions/binding\\[@name='[^']*'\\]/operation\\[@name='([^']*)'\\]", IBindingOperation.PROP_OPERATION_NAME),
        service("definitions/service\\[@name='([^']*)'\\]", IService.PROP_SERVICE_NAME, IServicePort.PROP_SERVICE_NAME),
        port("definitions/service\\[@name='[^']*'\\]/port\\[@name='([^']*)'\\]", IServicePort.PROP_PORT_NAME),
        messagePart("definitions/message\\[@name='[^']*'\\]/part\\[@name='([^']*)'\\]", "part", IOperationParameter.PROP_PART_NAME),
        message("definitions/message\\[@name='([^']*)'\\]", "part", IOperationParameter.PROP_MESSAGE_NAME),
        invalid("", new ValueProperty[0]){

            @Override
            public String getValue(String node, String wsdlPrefix) {
                throw new UnsupportedOperationException("No value for invalid");
            }

            @Override
            public String getValue(XmlElement element) {
                throw new UnsupportedOperationException("No value for invalid");
            }

            @Override
            public String setValue(String node, String wsdlPrefix, String value) {
                throw new UnsupportedOperationException("Can not set value for invalid");
            }

            @Override
            public boolean defines(String node, String wsdlPrefix) {
                Patterns[] patternsArray = 1.values();
                int n = patternsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Patterns p = patternsArray[n2];
                    if (p != this && p.defines(node, wsdlPrefix)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean applies(String node, String wsdlPrefix) {
                Patterns[] patternsArray = 1.values();
                int n = patternsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Patterns p = patternsArray[n2];
                    if (p != this && p.applies(node, wsdlPrefix)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean defines(XmlElement element) {
                Patterns[] patternsArray = 1.values();
                int n = patternsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Patterns p = patternsArray[n2];
                    if (p != this && p.defines(element)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean applies(XmlElement element) {
                Patterns[] patternsArray = 1.values();
                int n = patternsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Patterns p = patternsArray[n2];
                    if (p != this && p.applies(element)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public String getInitialValue(String prefix) {
                throw new UnsupportedOperationException("No initial value for invalid");
            }

            @Override
            public void setInitialValue(XmlElement element) {
                throw new UnsupportedOperationException("Can not set initial value for invalid");
            }
        };

        private final Pattern pattern;
        private final Pattern childrenPattern;
        private final String initialPath;
        private final String attributeName;
        private final Set<ValueProperty> applicable = new HashSet<ValueProperty>();

        private Patterns(String path, String attrName, ValueProperty ... properties) {
            this(path, false, attrName, properties);
        }

        private Patterns(String path, ValueProperty ... properties) {
            this(path, false, properties);
        }

        private Patterns(String path, boolean allowEmpty, ValueProperty ... properties) {
            this(path, allowEmpty, "node", properties);
        }

        private Patterns(String path, boolean allowEmpty, String attrName, ValueProperty ... properties) {
            String xpath = allowEmpty ? "^$|" + path : path;
            this.pattern = Pattern.compile(xpath);
            this.childrenPattern = Pattern.compile(String.valueOf(xpath) + ".*");
            String modified = path.replaceAll("\\\\", "");
            this.initialPath = modified.replaceAll("[(]?\\[\\^'\\]\\*[)]?", "");
            this.attributeName = attrName;
            ValueProperty[] valuePropertyArray = properties;
            int n2 = properties.length;
            int n3 = 0;
            while (n3 < n2) {
                ValueProperty prop = valuePropertyArray[n3];
                this.applicable.add(prop);
                ++n3;
            }
        }

        public static String determineWsdlNSPrefix(XmlElement element) {
            Document document = element.getDomNode().getOwnerDocument();
            Element root = document.getDocumentElement();
            NamedNodeMap map = root.getAttributes();
            if (map == null) {
                return null;
            }
            int i = 0;
            while (i < map.getLength()) {
                Attr a;
                Node o = map.item(i);
                if (o instanceof Attr && NodeNameBinding.WSDL_NS.equals((a = (Attr)o).getValue())) {
                    String name = a.getName();
                    if (name.indexOf(58) > 0) {
                        return name.substring("xmlns:".length());
                    }
                    return "";
                }
                ++i;
            }
            return null;
        }

        static String getValue(XmlElement element, ValueProperty property) {
            String prefix = Patterns.determineWsdlNSPrefix(element);
            if (prefix == null) {
                prefix = "";
            }
            Patterns[] patternsArray = Patterns.values();
            int n = patternsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern;
                Patterns p = patternsArray[n2];
                if (p.applicable.contains(property) && (pattern = element.getAttributeText(p.attributeName)) != null) {
                    return p.getValue(pattern, prefix);
                }
                ++n2;
            }
            return null;
        }

        static void setValue(XmlElement element, ValueProperty property, String value) {
            String prefix = Patterns.determineWsdlNSPrefix(element);
            if (prefix == null) {
                prefix = "";
            }
            Patterns patterns = null;
            Patterns[] patternsArray = Patterns.values();
            int n = patternsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Patterns p = patternsArray[n2];
                if (p.applicable.contains(property)) {
                    patterns = p;
                    break;
                }
                ++n2;
            }
            if (patterns == null) {
                throw new NullPointerException("unknown property: " + property.name());
            }
            String nodePath = element.getAttributeText(patterns.attributeName);
            if (nodePath == null || "".equals(nodePath)) {
                patterns.setInitialValue(element);
                nodePath = element.getAttributeText(patterns.attributeName);
            }
            String newPath = patterns.setValue(nodePath, prefix, value);
            element.setAttributeText(patterns.attributeName, newPath, false);
        }

        public static String addWsdlNS(String node, String ns) {
            if (ns == null || "".equals(ns)) {
                return node;
            }
            StringBuilder sb = new StringBuilder();
            String[] parts = node.split("/");
            int i = 0;
            while (i < parts.length) {
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(ns).append(':').append(parts[i]);
                ++i;
            }
            return sb.toString();
        }

        public String getValue(String node, String wsdlPrefix) {
            String nonPrefixedXPath = "".equals(wsdlPrefix) ? node : node.replaceAll(String.valueOf(wsdlPrefix) + ':', "");
            Matcher m = this.childrenPattern.matcher(nonPrefixedXPath);
            boolean matches = m.matches();
            int count = m.groupCount();
            return matches && count == 1 ? m.group(1) : null;
        }

        public String getValue(XmlElement element) {
            String node = element.getAttributeText(this.attributeName);
            String prefix = Patterns.determineWsdlNSPrefix(element);
            return this.getValue(node, prefix);
        }

        public String setValue(String node, String wsdlPrefix, String value) {
            String nonPrefixedXPath = "".equals(wsdlPrefix) ? node : node.replaceAll(String.valueOf(wsdlPrefix) + ':', "");
            Matcher m = this.childrenPattern.matcher(nonPrefixedXPath);
            boolean matches = m.matches();
            int count = m.groupCount();
            if (!matches || count != 1) {
                return null;
            }
            int start = m.start(1);
            int end = m.end(1);
            String modified = String.valueOf(nonPrefixedXPath.substring(0, start)) + value + nonPrefixedXPath.substring(end);
            return Patterns.addWsdlNS(modified, wsdlPrefix);
        }

        private boolean matches(Pattern p, String node, String wsdlPrefix) {
            String nonPrefixedXPath = "".equals(wsdlPrefix) ? node : node.replaceAll(String.valueOf(wsdlPrefix) + ':', "");
            return p.matcher(nonPrefixedXPath).matches();
        }

        public boolean defines(String node, String wsdlPrefix) {
            return this.matches(this.pattern, node, wsdlPrefix);
        }

        public boolean applies(String node, String wsdlPrefix) {
            return this.matches(this.childrenPattern, node, wsdlPrefix);
        }

        private boolean matches(Pattern p, XmlElement element) {
            String node = element.getAttributeText(this.attributeName);
            String prefix = Patterns.determineWsdlNSPrefix(element);
            return node != null ? this.matches(p, node, prefix) : false;
        }

        public boolean defines(XmlElement element) {
            return this.matches(this.pattern, element);
        }

        public boolean applies(XmlElement element) {
            return this.matches(this.childrenPattern, element);
        }

        public String getInitialValue(String prefix) {
            return Patterns.addWsdlNS(this.initialPath, prefix);
        }

        public void setInitialValue(XmlElement element) {
            String ns = Patterns.determineWsdlNSPrefix(element);
            String newValue = Patterns.addWsdlNS(this.initialPath, ns);
            element.setAttributeText(this.attributeName, newValue, false);
        }
    }
}

