/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.bindings.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.w3c.dom.Node;

public abstract class BindingsListController<BINDING_MODEL_TYPE extends Element>
extends StandardXmlListBindingImpl {
    public static final String EL_BINDINGS = "bindings";
    private final boolean includeRoot;
    private final NodeNameBinding.Patterns pattern;
    private final ElementType type;

    public BindingsListController(NodeNameBinding.Patterns pattern, ElementType type) {
        this(pattern, type, false);
    }

    public BindingsListController(NodeNameBinding.Patterns pattern, ElementType type, boolean includeRootElement) {
        this.includeRoot = includeRootElement;
        this.pattern = pattern;
        this.type = type;
    }

    protected void initBindingMetadata() {
        this.path = null;
        this.xmlElementNames = new QName[]{new QName(EL_BINDINGS)};
        this.modelElementTypes = new ElementType[]{this.type};
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        Object obj = this.insertUnderlyingObject(type);
        return obj;
    }

    private Object insertUnderlyingObject(ElementType type) {
        XmlElement parent = this.getXmlElement(true);
        XmlElement element = parent.addChildElement(EL_BINDINGS);
        this.pattern.setInitialValue(element);
        return element;
    }

    protected List<?> readUnderlyingList() {
        XmlElement parent = this.getXmlElement(false);
        ArrayList<XmlElement> previous = new ArrayList<XmlElement>();
        if (parent == null) {
            return Collections.emptyList();
        }
        for (XmlElement element : parent.getChildElements()) {
            QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
            if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
            previous.add(element);
        }
        ArrayList<XmlElement> list = new ArrayList<XmlElement>(previous.size());
        if (this.includeRoot && this.pattern.applies(parent)) {
            list.add(parent);
        }
        List bindings = parent.getChildElements(new QName(parent.getNamespace(), EL_BINDINGS));
        for (XmlElement element : bindings) {
            if (!this.pattern.defines(element)) continue;
            list.add(element);
        }
        return list;
    }
}

