/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.bindings;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.webservices.model.bindings.IDefinitions;
import oracle.eclipse.tools.webservices.model.bindings.IPortType;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperationFault;
import oracle.eclipse.tools.webservices.model.bindings.IService;
import oracle.eclipse.tools.webservices.model.bindings.IServicePort;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class AttributeValuePropertyBinding
extends XmlValueBindingImpl {
    public String read() {
        ValueProperty property = (ValueProperty)this.property().definition();
        assert (this.property().element().type() == property.getModelElementType());
        AttributeProperties[] attributePropertiesArray = AttributeProperties.values();
        int n = attributePropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeProperties prop = attributePropertiesArray[n2];
            if (prop.isFor(property)) {
                return prop.getText(this.xml(false));
            }
            ++n2;
        }
        return null;
    }

    public void write(String value) {
        Element element = this.property().element();
        ValueProperty property = (ValueProperty)this.property().definition();
        assert (element.type() == property.getModelElementType());
        AttributeProperties[] attributePropertiesArray = AttributeProperties.values();
        int n = attributePropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeProperties prop = attributePropertiesArray[n2];
            if (prop.isFor(property)) {
                prop.setText(this.xml(true), element, value);
            }
            ++n2;
        }
    }

    static final class AttributeProperties
    extends Enum<AttributeProperties> {
        public static final /* enum */ AttributeProperties class_name = new AttributeProperties(IPortType.PROP_CLASS_NAME, IPortType.PROP_PORT_TYPE_NAME, "class/@name");
        public static final /* enum */ AttributeProperties method_name = new AttributeProperties(IPortTypeOperation.PROP_METHOD_NAME, IPortTypeOperation.PROP_OPERATION_NAME, "method/@name");
        public static final /* enum */ AttributeProperties fault_class_name = new AttributeProperties(IPortTypeOperationFault.PROP_CLASS_NAME, IPortTypeOperationFault.PROP_FAULT_NAME, "class/@name");
        public static final /* enum */ AttributeProperties service_class_name = new AttributeProperties(IService.PROP_CLASS_NAME, IService.PROP_SERVICE_NAME, "class/@name");
        public static final /* enum */ AttributeProperties service_port_method_name = new AttributeProperties(IServicePort.PROP_METHOD_NAME, null, "method/@name");
        public static final /* enum */ AttributeProperties package_name = new AttributeProperties(IDefinitions.PROP_PACKAGE_NAME, null, "package/@name");
        private final ValueProperty property;
        private final ValueProperty defProperty;
        private final String xpath;
        private static final /* synthetic */ AttributeProperties[] ENUM$VALUES;

        static {
            ENUM$VALUES = new AttributeProperties[]{class_name, method_name, fault_class_name, service_class_name, service_port_method_name, package_name};
        }

        private AttributeProperties(ValueProperty base, ValueProperty defaultProperty, String path) {
            this.property = base;
            this.defProperty = defaultProperty;
            assert (this.defProperty == null || this.property.getModelElementType() == defaultProperty.getModelElementType());
            this.xpath = path;
        }

        String getText(XmlElement element) {
            return element.getChildNodeText(this.xpath);
        }

        boolean isFor(ValueProperty p) {
            return this.property == p;
        }

        void setText(XmlElement xml, Element element, String value) {
            String oldValue = this.getText(xml);
            if (!ObjectUtil.equal((Object)oldValue, (Object)value)) {
                XmlPath path = new XmlPath(this.xpath);
                List segments = path.getSegments();
                ArrayList copied = new ArrayList(segments);
                copied.remove(copied.size() - 1);
                XmlPath parentPath = new XmlPath(copied);
                XmlNode node = xml.getChildNode(path, true);
                XmlElement parent = (XmlElement)xml.getChildNode(parentPath, true);
                node.setText(value);
                if (value == null) {
                    ValueProperty vp;
                    Value v;
                    List children = parent.getChildElements();
                    boolean isEmpty = true;
                    for (XmlElement child : children) {
                        if (child.getDomNode().getNodeType() == 3) continue;
                        isEmpty = false;
                        break;
                    }
                    if (isEmpty) {
                        parent.remove();
                    } else if (this.defProperty != null && (v = element.property(vp = (ValueProperty)element.type().property(this.defProperty.name()))) != null) {
                        node.setText(v.text());
                    }
                }
            }
        }

        public static AttributeProperties[] values() {
            AttributeProperties[] attributePropertiesArray = ENUM$VALUES;
            int n = attributePropertiesArray.length;
            AttributeProperties[] attributePropertiesArray2 = new AttributeProperties[n];
            System.arraycopy(ENUM$VALUES, 0, attributePropertiesArray2, 0, n);
            return attributePropertiesArray2;
        }

        public static AttributeProperties valueOf(String string) {
            return Enum.valueOf(AttributeProperties.class, string);
        }
    }
}

