/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.model.MapNamespaceContext;
import oracle.eclipse.tools.webservices.model.WsdlParseFaildedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LightweightWsdlModel {
    private Map<String, Collection<String>> serviceNameToPortName = new LinkedHashMap<String, Collection<String>>();
    private Map<String, String> serviceNameToPrefix = new HashMap<String, String>();
    private Map<String, String> serviceNameToNamespace = new HashMap<String, String>();
    private Map<String, Collection<String>> operationToBindingUse = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> bindingStyles = new HashMap<String, Collection<String>>();
    private URI wsdlURI;
    private String targetNamespace;
    private Map<String, Collection<String>> portTypeOperations = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> operationFaults = new HashMap<String, Collection<String>>();
    private boolean hasPolicies = false;

    public LightweightWsdlModel(URI uri) throws WsdlParseFaildedException {
        this.wsdlURI = uri;
        this.parseWsdlInternal(uri);
    }

    public URI getWsdlURI() {
        return this.wsdlURI;
    }

    public Collection<String> getServices() {
        return this.serviceNameToPortName.keySet();
    }

    public Map<String, Collection<String>> getPorts() {
        return this.serviceNameToPortName;
    }

    public Map<String, Collection<String>> getOperationalBindings() {
        return this.operationToBindingUse;
    }

    public Map<String, Collection<String>> getOperationalBindingsStyle() {
        return this.bindingStyles;
    }

    public Map<String, Collection<String>> getPortTypeOperations() {
        return this.portTypeOperations;
    }

    public Map<String, Collection<String>> getFaults() {
        return this.operationFaults;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean hasPolicies() {
        return this.hasPolicies;
    }

    private void parseWsdlInternal(URI f) throws WsdlParseFaildedException {
        this.parseWsdlInternal(f, new LinkedHashSet<String>(), false);
        if (this.serviceNameToPortName.size() == 0) {
            throw new WsdlParseFaildedException(Messages.lightweight_wsdl_model_no_services);
        }
    }

    private void parseWsdlInternal(URI wsdl, Set<String> previousImports, boolean isImportWsdl) throws WsdlParseFaildedException {
        if (!previousImports.add(wsdl.toString())) {
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            NodeList nl;
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(wsdl.toString());
            XPath xpath = this.createXPath();
            if (this.targetNamespace == null) {
                nl = this.parseNodes(doc, xpath, "wsdl:definitions");
                int i = 0;
                while (i < nl.getLength()) {
                    this.targetNamespace = this.parseNodeAttribute(nl.item(i), "targetNamespace", "");
                    if (this.targetNamespace != null && this.targetNamespace.trim().length() == 0) {
                        this.targetNamespace = null;
                    }
                    ++i;
                }
            }
            if ((nl = this.parseNodes(doc, xpath, "//wsp:Policy")).getLength() > 0) {
                this.hasPolicies = true;
            }
            this.checkForImports(wsdl, previousImports, doc, xpath);
            if (!isImportWsdl) {
                this.translateDomToMap(doc, xpath, "//wsdl:service", "wsdl:port", "name", "name", this.serviceNameToPortName);
                this.translateDomToPrefixNamespaceMap(doc, xpath, "//wsdl:service", "name", this.serviceNameToPrefix, this.serviceNameToNamespace, null);
            }
            this.translateDomToMap(doc, xpath, "//wsdl:operation", "*/soap:body", "name", "use", this.operationToBindingUse);
            this.translateDomToMap(doc, xpath, "//wsdl:binding", "soap:binding", "name", "style", this.bindingStyles, "document");
            this.translateDomToMap(doc, xpath, "//wsdl:portType", "wsdl:operation", "name", "name", this.portTypeOperations);
            this.translateDomToMap(doc, xpath, "//wsdl:portType/wsdl:operation", "wsdl:fault", "name", "name", this.operationFaults);
        }
        catch (IOException e) {
            throw new WsdlParseFaildedException(Messages.bind((String)Messages.lightweight_wsdl_model_error_parsing_wsdl, (Object[])new Object[]{wsdl.toString(), e.getClass().getSimpleName(), e.getLocalizedMessage()}), e);
        }
        catch (ParserConfigurationException e) {
            throw new WsdlParseFaildedException(e);
        }
        catch (SAXException e) {
            throw new WsdlParseFaildedException(e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            throw new WsdlParseFaildedException(e);
        }
    }

    private void translateDomToMap(Object item, XPath xpath, String parent, String expression, String parentAttribute, String attribute, Map<String, Collection<String>> valuesMap) throws WsdlParseFaildedException {
        this.translateDomToMap(item, xpath, parent, expression, parentAttribute, attribute, valuesMap, null);
    }

    private void translateDomToMap(Object item, XPath xpath, String parent, String expression, String parentAttribute, String attribute, Map<String, Collection<String>> valuesMap, String defaultAttributeValue) throws WsdlParseFaildedException {
        NodeList nodelist = this.parseNodes(item, xpath, parent);
        int i = 0;
        while (i < nodelist.getLength()) {
            Node n = nodelist.item(i);
            String value = this.parseNodeAttribute(n, parentAttribute, defaultAttributeValue);
            NodeList subList = this.parseNodes(n, xpath, expression);
            Collection<String> sub = valuesMap.get(value);
            if (sub == null) {
                sub = new ArrayList<String>();
                valuesMap.put(value, sub);
            }
            int j = 0;
            while (j < subList.getLength()) {
                sub.add(this.parseNodeAttribute(subList.item(j), attribute, defaultAttributeValue));
                ++j;
            }
            ++i;
        }
    }

    private void translateDomToPrefixNamespaceMap(Object item, XPath xpath, String parent, String parentAttribute, Map<String, String> prefixMap, Map<String, String> nameSpaceMap, String defaultAttributeValue) throws WsdlParseFaildedException {
        NodeList nodelist = this.parseNodes(item, xpath, parent);
        int i = 0;
        while (i < nodelist.getLength()) {
            Node n = nodelist.item(i);
            String value = this.parseNodeAttribute(n, parentAttribute, defaultAttributeValue);
            prefixMap.put(value, n.getPrefix());
            nameSpaceMap.put(value, n.getNamespaceURI());
            ++i;
        }
    }

    private String parseNodeAttribute(Node n, String attribute, String defaultValue) throws WsdlParseFaildedException {
        if (!(n instanceof Element)) {
            throw new WsdlParseFaildedException("expecting an Element found: " + n);
        }
        Element element = (Element)n;
        String name = element.getAttribute(attribute);
        if ((name = name.trim()).length() == 0) {
            if (defaultValue == null) {
                throw new WsdlParseFaildedException(Messages.bind((String)Messages.lightweight_wsdl_model_missing_attribute, (Object)attribute));
            }
            return defaultValue;
        }
        return name;
    }

    private NodeList parseNodes(Object item, XPath xpath, String expression) throws WsdlParseFaildedException {
        NodeList nodelist;
        try {
            nodelist = (NodeList)xpath.evaluate(expression, item, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return nodelist;
    }

    private void checkForImports(URI wsdl, Set<String> previousImports, Document doc, XPath xpath) throws WsdlParseFaildedException {
        try {
            NodeList wsdlImports = (NodeList)xpath.evaluate("//wsdl:import", doc, XPathConstants.NODESET);
            int i = 0;
            while (i < wsdlImports.getLength()) {
                URI anImport;
                Element serviceElement = (Element)wsdlImports.item(i);
                String location = serviceElement.getAttribute("location");
                try {
                    anImport = new URL(wsdl.toURL(), location).toURI().normalize();
                }
                catch (IOException e) {
                    throw new WsdlParseFaildedException(Messages.bind((String)Messages.lightweight_wsdl_model_import_failed, (Object)location), e);
                }
                catch (URISyntaxException e) {
                    throw new WsdlParseFaildedException(Messages.bind((String)Messages.lightweight_wsdl_model_import_failed, (Object)location), e);
                }
                this.parseWsdlInternal(anImport, previousImports, true);
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private XPath createXPath() {
        MapNamespaceContext mapNamespaceContext = new MapNamespaceContext();
        mapNamespaceContext.put("xs", "http://www.w3.org/2001/XMLSchema");
        mapNamespaceContext.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        mapNamespaceContext.put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        mapNamespaceContext.put("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(mapNamespaceContext);
        return xPath;
    }

    public Map<String, String> getServicePrefix() {
        return this.serviceNameToPrefix;
    }

    public Map<String, String> getServiceNamespace() {
        return this.serviceNameToNamespace;
    }
}

