/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.jwsc;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.WebServicesException;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.util.ClassPathBuilder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ResourceStoreException;

public class JwscArguments
extends CommonWebServiceAntTaskArguments {
    private IContainer srcDir;
    private IPath destDir;
    private IPath wsdlWorkingDir;
    private IFile wsdlFile;
    private IFile schemaFile;
    private IPath projectDestDir;
    private IFile implFile;
    private boolean wsdlOnly = false;
    private boolean shouldInsertClasspath = false;
    private Collection<String> classPath;

    public JwscArguments(IProject project) {
        this.setProject(project);
    }

    public IContainer getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(IContainer srcDir) {
        this.srcDir = srcDir;
    }

    public IPath getDestDir() {
        return this.destDir;
    }

    public void setDestDir(IPath destDir) {
        this.destDir = destDir;
    }

    public IPath getWsdlWorkingDir() {
        return this.wsdlWorkingDir;
    }

    public void setWsdlWorkingDir(IPath wsdlWorkingDir) {
        this.wsdlWorkingDir = wsdlWorkingDir;
    }

    public IFile getImplFile() {
        return this.implFile;
    }

    public void setImplFile(IFile implFile) {
        this.implFile = implFile;
    }

    public boolean isWsdlOnly() {
        return this.wsdlOnly;
    }

    public void setWsdlOnly(boolean wsdlOnly) {
        this.wsdlOnly = wsdlOnly;
    }

    public IFile getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(IFile wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public IFile getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(IFile schemaFile) {
        this.schemaFile = schemaFile;
    }

    public void setProjectClasspath(boolean shouldInsertClasspath) {
        this.shouldInsertClasspath = shouldInsertClasspath;
        if (shouldInsertClasspath) {
            this.classPath = this.initClasspathDir();
        }
    }

    public boolean isProjectClasspath() {
        return this.shouldInsertClasspath;
    }

    public Collection<String> getClassPath() {
        return this.classPath;
    }

    public void setProjectDestDir(IPath projectDestDir) {
        this.projectDestDir = projectDestDir;
    }

    public IPath getProjectDestDir() {
        return this.projectDestDir;
    }

    public String getJwscPathEntry() {
        StringBuffer buffer = new StringBuffer();
        try {
            HashSet<String> set = new HashSet<String>();
            ISystemLibrariesContainerDef def = SystemLibrariesContainer.getContainerDef((IProject)this.getProject());
            ElementList syslibs = def.getSystemLibraries();
            for (ISystemLibrary sis : syslibs) {
                set.add(sis.getResolvedPath().toString());
            }
            for (String path : set) {
                if (path.contains("<null>")) continue;
                File file = new File(path);
                buffer.append(file.getCanonicalPath());
                buffer.append(File.pathSeparator);
            }
        }
        catch (ResourceStoreException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
        }
        return buffer.toString();
    }

    public Collection<String> initClasspathDir() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return this.buildClassPath(javaProject);
        }
        catch (WebServicesException wEx) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (Throwable)wEx);
        }
        catch (IOException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private Collection<String> buildClassPath(IJavaProject jp) throws WebServicesException, IOException {
        List<String> cpCollection = Collections.emptyList();
        try {
            Collection<String> paths = ClassPathBuilder.buildClassPath(jp);
            Iterator<String> iter = paths.iterator();
            URL[] runtimeURLS = this.getToolsRuntimeClasspath();
            if (runtimeURLS != null) {
                Collection<String> urlCol = this.convertPaths(runtimeURLS);
                cpCollection = new ArrayList();
                while (iter.hasNext()) {
                    String path = iter.next();
                    File file = new File(path);
                    if (this.isPresent(urlCol, file.getCanonicalPath())) continue;
                    cpCollection.add(path);
                }
                return cpCollection;
            }
            return paths;
        }
        catch (JavaModelException e) {
            throw new WebServicesException(e);
        }
    }

    private boolean isPresent(Collection<String> urls, String path) {
        for (String url : urls) {
            if (!url.contains(path)) continue;
            return true;
        }
        return false;
    }

    private Collection<String> convertPaths(URL[] urls) throws IOException {
        ArrayList<String> cP = new ArrayList<String>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            try {
                String decode = URLDecoder.decode(url.getFile(), "UTF-8");
                File file = new File(decode);
                String canPath = file.getCanonicalPath();
                cP.add(canPath);
            }
            catch (UnsupportedEncodingException e) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        return cP;
    }
}

