/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.jwsc;

import com.bea.wlw.template.ITemplateBean;
import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.ant.UnexpectedFileStateException;
import oracle.eclipse.tools.webservices.ant.WlsAntScript;
import oracle.eclipse.tools.webservices.jwsc.JwscArguments;
import oracle.eclipse.tools.webservices.jwsc.JwscTemplateBean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class JwscAntScript
extends WlsAntScript<JwscArguments> {
    public static final String TEMPLATE_ID = "oracle.eclipse.tools.webservices.jwsc";

    public JwscAntScript(JwscArguments args) {
        super(args, TEMPLATE_ID);
    }

    @Override
    protected ITemplateBean createTemplateBean() {
        return new JwscTemplateBean((JwscArguments)this.getArguments());
    }

    @Override
    protected IResource[] refreshList() {
        IFile wsdlFile = ((JwscArguments)this.getArguments()).getWsdlFile();
        if (wsdlFile != null) {
            return new IResource[]{wsdlFile.getParent()};
        }
        return new IResource[]{((JwscArguments)this.getArguments()).getSchemaFile(), ((JwscArguments)this.getArguments()).getWsdlFile()};
    }

    @Override
    protected boolean validateFileState(IProgressMonitor monitor) throws UnexpectedFileStateException {
        IPath destPath = ((JwscArguments)this.getArguments()).getDestDir();
        File destDir = destPath.toFile();
        if (destDir != null && destDir.exists()) {
            try {
                FileUtil.delete((File)destDir);
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return true;
    }
}

