/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.export;

import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public abstract class AbstractExportOperation
extends AbstractDataModelOperation {
    private boolean exportedEarOrWarNoGoodDialogHasBeenShown = false;

    public final IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.exportedEarOrWarNoGoodDialogHasBeenShown = false;
        try {
            IVirtualComponent rootComponent = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
            IProject rootProject = rootComponent.getProject();
            if (WlsEarFacet.isInstalled((IProject)rootProject)) {
                IVirtualReference[] refs;
                IVirtualReference[] iVirtualReferenceArray = refs = rootComponent.getReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    IProject project = ref.getReferencedComponent().getProject();
                    this.processModule(monitor, project);
                    ++n2;
                }
            } else {
                this.processModule(monitor, rootProject);
            }
            return OK_STATUS;
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
            throw new ExecutionException(Messages.export_operation_failed, (Throwable)e);
        }
    }

    protected void showExportedEarOrWarNoGoodDialogIfNotShownDuringThisExport() {
        if (!this.exportedEarOrWarNoGoodDialogHasBeenShown) {
            DialogService.showErrorDialog((String)Messages.export_contents_incomplete_no_runtime);
            this.exportedEarOrWarNoGoodDialogHasBeenShown = true;
        }
    }

    protected abstract void processModule(IProgressMonitor var1, IProject var2) throws ExecutionException;
}

