/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

public class PortInfo {
    private String contextPath = null;
    private String serviceUri = null;
    private String portName = null;
    protected String protocol = "http";

    public PortInfo() {
    }

    public PortInfo(String contextPath, String serviceUri, String portName) {
        this.contextPath = contextPath;
        this.serviceUri = serviceUri;
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getNormalizedPath() {
        return String.valueOf(PortInfo.normalizePath(this.getContextPath())) + "/" + this.getServiceUri();
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public void setServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getURI() {
        StringBuffer uri = new StringBuffer(this.getProtocol());
        if ("https".equals(this.getProtocol())) {
            uri.append("://localhost:7002");
        } else {
            uri.append("://localhost:7001");
        }
        uri.append(PortInfo.normalizePath(this.getContextPath()));
        uri.append(this.getServiceUri());
        return uri.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortInfo)) {
            return false;
        }
        PortInfo port = (PortInfo)o;
        if (this.contextPath != null ? !this.contextPath.equals(port.contextPath) : port.contextPath != null) {
            return false;
        }
        if (this.portName != null ? !this.portName.equals(port.portName) : port.portName != null) {
            return false;
        }
        return !(this.serviceUri != null ? !this.serviceUri.equals(port.serviceUri) : port.serviceUri != null);
    }

    public int hashCode() {
        int result = this.contextPath != null ? this.contextPath.hashCode() : 0;
        result = 29 * result + (this.serviceUri != null ? this.serviceUri.hashCode() : 0);
        result = 29 * result + (this.portName != null ? this.portName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{" + this.getPortName() + "}" + this.getURI();
    }

    public static String normalizePath(String toNormalize) {
        String normalized = toNormalize.replace('\\', '/');
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        return normalized;
    }
}

