/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.ws.Provider;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.compiler.PortInfo;
import oracle.eclipse.tools.webservices.compiler.PortInfoFactory;
import oracle.eclipse.tools.webservices.compiler.WsdlDefinitionReader;
import oracle.eclipse.tools.webservices.jdt.JaxwsModel;
import oracle.eclipse.tools.webservices.jdt.TypeElement;
import oracle.eclipse.tools.webservices.jdt.annotation.BindingTypeAnnotation;
import oracle.eclipse.tools.webservices.jdt.annotation.WebServiceAnnotation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class Jws {
    protected final TypeElement sbClass;
    protected TypeElement eiClass;
    private final String name;
    protected final String serviceName;
    protected final JaxwsModel jaxwsModel;
    protected String targetNamespace = null;
    protected String wsdlLocation;
    private final String endPointInterface;
    private final String className;
    private final String simpleName;
    private final String packageName;
    private final QName portQName;
    private boolean conversational = false;
    protected String portTypeNamespaceURI = null;
    private String protocolBinding;
    private boolean mtomEnabled = false;
    private boolean providerBasedEndpoint = false;
    private boolean cowFileComputed = false;
    private IFile cowFile = null;
    private boolean isGenerateWsdl = false;
    private boolean isGenerateDescriptors = false;
    private boolean wsdlReaderComputed = false;
    private WsdlDefinitionReader wsdlReader = null;
    private final Set<PortInfo> ports = new HashSet<PortInfo>();

    public Jws(TypeElement jwsClass, JaxwsModel parent, boolean initHandlerChanin) {
        this.eiClass = this.sbClass = jwsClass;
        this.jaxwsModel = parent;
        this.providerBasedEndpoint = this.isProviderBasedEndpoint(this.sbClass.getTypeDeclaration(), this.jaxwsModel.getProject());
        WebServiceAnnotation sbWebServiceAnn = this.sbClass.getWebServiceAnnotation();
        String eiInterface = null;
        if (sbWebServiceAnn.hasAnnotation()) {
            eiInterface = sbWebServiceAnn.getEndpointInterface();
            this.eiClass = this.sbClass.getEiTypeElement();
        }
        WebServiceAnnotation eiWebServiceAnn = this.eiClass.getWebServiceAnnotation();
        this.endPointInterface = eiInterface;
        this.className = this.sbClass.getQualifiedName();
        this.simpleName = this.sbClass.getSimpleName();
        this.packageName = StringUtil.getPackage((String)this.className);
        this.name = this.getPortTypeName(eiWebServiceAnn);
        this.initNamespaces(sbWebServiceAnn, eiWebServiceAnn);
        this.serviceName = this.buildServiceName(this.sbClass, sbWebServiceAnn);
        this.wsdlLocation = eiWebServiceAnn.getWsdlLocation();
        if (this.wsdlLocation == null) {
            this.wsdlLocation = sbWebServiceAnn.getWsdlLocation();
        }
        String portName = this.buildPortName(sbWebServiceAnn);
        this.portQName = new QName(this.targetNamespace, portName);
        BindingTypeAnnotation bindingTypeAnn = this.sbClass.getBindingTypeAnnotation();
        this.protocolBinding = bindingTypeAnn.getValue();
        if (StringUtil.isEmpty((String)this.protocolBinding)) {
            this.protocolBinding = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        this.mtomEnabled = "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(this.protocolBinding);
        this.initPortInfo();
    }

    private void initPortInfo() {
        PortInfoFactory factory = new PortInfoFactory(this, this.getServiceQName(), this.getPortName());
        factory.setWsdlLocation(this.wsdlLocation);
        WebServiceProject wsPro = new WebServiceProject(this.jaxwsModel.getProject());
        factory.setContextPath(wsPro.getContextRoot());
        this.ports.addAll(factory.buildPorts());
    }

    public WsdlDefinitionReader getWsdlReader() {
        if (!this.wsdlReaderComputed) {
            IFile cowFile = this.getCowFile();
            if (cowFile != null) {
                this.wsdlReader = this.getCowReader(cowFile);
            }
            this.wsdlReaderComputed = true;
        }
        return this.wsdlReader;
    }

    private WsdlDefinitionReader getCowReader(IFile cowFile) {
        return new WsdlDefinitionReader(cowFile.getLocation().toFile());
    }

    public IFile getCowFile() {
        if (!this.cowFileComputed) {
            this.cowFile = Jws.findCowFile(this.sbClass, this.jaxwsModel.getJavaProject());
        }
        return this.cowFile;
    }

    public boolean isGenerateWsdl() {
        return this.isGenerateWsdl;
    }

    public void setGenerateWsdl(boolean generateWsdl) {
        this.isGenerateWsdl = generateWsdl;
    }

    public boolean isGenerateDescriptors() {
        return this.isGenerateDescriptors;
    }

    public void setGenerateDescriptors(boolean generateDescriptors) {
        this.isGenerateDescriptors = generateDescriptors;
    }

    public String getOutputEncoding() {
        return null;
    }

    public File[] getIncludeSchemas() {
        return null;
    }

    private static IFile findCowFile(TypeElement jclass, IJavaProject javaProject) {
        IFile cowFile;
        WebServiceAnnotation webServiceAnno = jclass.getWebServiceAnnotation();
        if (!webServiceAnno.hasAnnotation()) {
            return null;
        }
        String endpointInterfaceName = webServiceAnno.getEndpointInterface();
        if (endpointInterfaceName != null && javaProject != null && (cowFile = Jws.findCowFile(javaProject, endpointInterfaceName)) != null) {
            return cowFile;
        }
        return null;
    }

    public static IFile findCowFile(IJavaProject javaProject, String typeName) {
        try {
            IPackageFragmentRoot pkgRoot;
            IType type = javaProject.findType(typeName);
            if (type != null && (pkgRoot = (IPackageFragmentRoot)type.getAncestor(3)) != null && pkgRoot.isArchive()) {
                IResource res = pkgRoot.getUnderlyingResource();
                if (res != null) {
                    if (res.getType() == 1) {
                        return (IFile)res;
                    }
                } else {
                    IWorkspaceRoot root;
                    String rootLocation;
                    String path = pkgRoot.getPath().toString();
                    if (path.startsWith(rootLocation = (root = ResourcesPlugin.getWorkspace().getRoot()).getLocation().toString())) {
                        String workspaceRelative = path.substring(rootLocation.length());
                        return root.getFile((IPath)new Path(workspaceRelative));
                    }
                }
            }
            return null;
        }
        catch (JavaModelException e) {
            LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
            return null;
        }
    }

    private boolean isProviderBasedEndpoint(TypeDeclaration jClass, IProject project) {
        return ClassUtil.isAssignableFrom((String)jClass.getQualifiedName(), (String)Provider.class.getName(), (IProject)project);
    }

    private String buildServiceName(TypeElement sbClass, WebServiceAnnotation sbWebServiceAnn) {
        String serviceName = sbWebServiceAnn.getServiceName();
        if (!StringUtil.isEmpty((String)serviceName)) {
            return serviceName;
        }
        return String.valueOf(this.simpleName) + "Service";
    }

    private String buildPortName(WebServiceAnnotation sbWebServiceAnn) {
        String portName = sbWebServiceAnn.getPortName();
        if (!StringUtil.isEmpty((String)portName)) {
            return portName;
        }
        String name = sbWebServiceAnn.getName();
        if (!StringUtil.isEmpty((String)name)) {
            return String.valueOf(name) + "Port";
        }
        if (StringUtil.isEmpty((String)this.endPointInterface)) {
            return String.valueOf(this.getPortType().trim()) + "Port";
        }
        return String.valueOf(this.simpleName) + "Port";
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public QName getServiceQName() {
        return new QName(this.targetNamespace, this.serviceName);
    }

    public String getEndPointInterface() {
        return this.endPointInterface;
    }

    public String getPortComponentName() {
        if (this.providerBasedEndpoint) {
            return this.getClassName();
        }
        if (StringUtil.isEmpty((String)this.endPointInterface)) {
            return this.getPortType();
        }
        return this.getSimpleName();
    }

    public String getPortType() {
        return this.name;
    }

    public String getPortTypeNamespaceURI() {
        return this.portTypeNamespaceURI;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public QName getPortTypeQName() {
        return new QName(this.getPortTypeNamespaceURI(), this.getPortType());
    }

    public TypeElement getSBElement() {
        return this.sbClass;
    }

    public TypeElement getEIElement() {
        return this.eiClass;
    }

    protected void initNamespaces(WebServiceAnnotation sbWebServiceAnn, WebServiceAnnotation eiWebServiceAnn) {
        this.portTypeNamespaceURI = eiWebServiceAnn.getTargetNamespace();
        this.targetNamespace = sbWebServiceAnn.getTargetNamespace();
        if (StringUtil.isEmpty((String)this.targetNamespace)) {
            if (!StringUtil.isEmpty((String)this.portTypeNamespaceURI)) {
                this.targetNamespace = this.portTypeNamespaceURI;
            } else {
                String packageName = this.eiClass.getQualifiedName();
                int index = packageName.lastIndexOf(".");
                if (index != -1) {
                    packageName = packageName.substring(0, index);
                }
                this.targetNamespace = Jws.getNamespace(packageName);
            }
        }
        if (StringUtil.isEmpty((String)this.portTypeNamespaceURI)) {
            this.portTypeNamespaceURI = this.targetNamespace;
        }
    }

    public boolean isConversational() {
        return this.conversational;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public String getPortName() {
        return this.portQName.getLocalPart();
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public Iterator<PortInfo> getPorts() {
        return this.ports.iterator();
    }

    private String getPortTypeName(WebServiceAnnotation eiWebServiceAnn) {
        String name = eiWebServiceAnn.getName();
        if (StringUtil.isEmpty((String)name)) {
            String simpleName = this.eiClass.getSimpleName();
            if (simpleName.indexOf("$") != -1) {
                simpleName = simpleName.substring(simpleName.indexOf("$") + 1);
            }
            StringBuilder defaultName = new StringBuilder();
            defaultName.append(simpleName);
            name = defaultName.toString();
        }
        return name.replace('$', '_');
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            int i = tokenizer.countTokens() - 1;
            while (i >= 0) {
                tokens[i] = tokenizer.nextToken();
                --i;
            }
        }
        StringBuffer namespace = new StringBuffer("http://");
        String dot = "";
        int i = 0;
        while (i < tokens.length) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(String.valueOf(dot) + tokens[i]);
            ++i;
        }
        namespace.append('/');
        return namespace.toString();
    }
}

