/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import javax.wsdl.Definition;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;

public class CompilerUtil {
    public static void copyWsdlsFromWebInfToWebRoot(WebServiceProject wsProject, IProgressMonitor monitor) throws CoreException {
        IFolder srcFolder = wsProject.getInputWebInf().getFolder("wsdls");
        if (!srcFolder.exists()) {
            return;
        }
        IPath dstPath = wsProject.getOutputWsdlFolder();
        File dstFolder = new File(dstPath.toOSString());
        if (dstFolder.exists()) {
            try {
                FileUtil.delete((File)dstFolder);
            }
            catch (IOException e) {
                IStatus status = WebServicesCorePlugin.createStatus(null, e);
                throw new CoreException(status);
            }
        }
        try {
            FileUtil.copy((File)new File(srcFolder.getLocationURI()), (File)dstFolder);
        }
        catch (IOException e) {
            IStatus status = WebServicesCorePlugin.createStatus(null, e);
            throw new CoreException(status);
        }
        Collection<IFile> wsdlFiles = WebServiceProject.getFilesWithExtension((IContainer)srcFolder, "wsdl");
        for (IFile wsdl : wsdlFiles) {
            if (!wsdl.exists()) continue;
            try {
                File newWsdlFile = new File(dstFolder, wsdl.getName());
                Definition definition = WSDLUtils.readWSDL((URL)wsdl.getLocationURI().toURL());
                WSDLUtils.writeWSDL((URL)newWsdlFile.toURI().toURL(), (Definition)definition);
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)ioe, (String)("Failed to copy " + wsdl.getName() + " and imported files to " + dstFolder));
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)ce, (String)("Failed to copy " + wsdl.getName() + " and imported files to " + dstFolder));
            }
        }
    }

    public static void copyPoliciesFromWebInfToWebRootWebInf(WebServiceProject wsProject, IProgressMonitor monitor) throws CoreException {
        IFolder srcFolder = wsProject.getInputPoliciesFolder();
        if (!srcFolder.exists()) {
            return;
        }
        IPath dstPath = wsProject.getOutputPoliciesFolder();
        File dstFolder = new File(dstPath.toOSString());
        if (dstFolder.exists()) {
            try {
                FileUtil.delete((File)dstFolder);
            }
            catch (IOException e) {
                IStatus status = WebServicesCorePlugin.createStatus(null, e);
                throw new CoreException(status);
            }
        }
        try {
            FileUtil.copy((File)new File(srcFolder.getLocationURI()), (File)dstFolder);
        }
        catch (IOException e) {
            IStatus status = WebServicesCorePlugin.createStatus(null, e);
            throw new CoreException(status);
        }
    }
}

