/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ant;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;

public abstract class WsdlBasedAntTaskArguments
extends CommonWebServiceAntTaskArguments {
    private LightweightWsdlModel model;

    public final void setWsdlModel(LightweightWsdlModel model) {
        this.model = model;
        IFile file = this.getWsdlIFile();
        if (file != null) {
            this.setProject(file.getProject());
        }
    }

    public final LightweightWsdlModel getWsdlModel() {
        return this.model;
    }

    public final IFile getWsdlIFile() {
        if (this.model == null) {
            return null;
        }
        return this.translateToIFile(this.model.getWsdlURI());
    }

    public final URL getWsdlURL() {
        if (this.model == null) {
            return null;
        }
        return this.translateToURL(this.model.getWsdlURI());
    }

    public final String getWsdlPathAsString() {
        if (this.model == null) {
            return null;
        }
        URI uri = this.model.getWsdlURI();
        IFile file = this.translateToIFile(uri);
        if (file != null) {
            return file.getProjectRelativePath().toPortableString();
        }
        URL url = this.translateToURL(uri);
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    private IFile translateToIFile(URI uri) {
        if (uri.isAbsolute() && !uri.getScheme().contains("file")) {
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        return files == null || files.length < 1 ? null : files[0];
    }

    private URL translateToURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException murle) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)murle);
            return null;
        }
    }
}

