/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ant;

import com.bea.wlw.template.TemplateBeanAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public abstract class CommonWebServiceAntTaskTemplateBean
extends TemplateBeanAdapter {
    private final CommonWebServiceAntTaskArguments arguments;

    protected CommonWebServiceAntTaskTemplateBean(CommonWebServiceAntTaskArguments args) {
        this.arguments = args;
    }

    public String getProjectName() {
        return this.arguments.getProject().getName();
    }

    public boolean getHas92Runtime() {
        return WlsRuntimeComponentType.VERSION_9_2 == WlsRuntimeUtil.getWlsRuntimeVersion((IProject)this.arguments.getProject());
    }

    public String getType() {
        return this.arguments.getWebServiceTypeAsString();
    }

    public String getBasedir() {
        IFile antscript = this.arguments.getAntScript();
        if (antscript == null) {
            return this.arguments.getProject().getLocation().toPortableString();
        }
        int segmentsToProject = antscript.getProjectRelativePath().segmentCount() - 1;
        if (segmentsToProject < 1) {
            return ".";
        }
        StringBuilder pathToProjectFromScript = new StringBuilder("..");
        int i = 1;
        while (i < segmentsToProject) {
            pathToProjectFromScript.append("/..");
            ++i;
        }
        return pathToProjectFromScript.toString();
    }

    public String getTypeFamily() {
        return this.arguments.getTypeFamilyAsString();
    }

    public String getPackageName() {
        return this.arguments.getPackageName();
    }

    public boolean shouldInsertClasspath() {
        return this.arguments.shouldInsertClasspath();
    }

    public String getClassesDir() {
        return this.arguments.getClassesDir();
    }

    protected List<MapTemplateBean> getMapTemplateBeans(Collection<Map.Entry<String, String>> items) {
        ArrayList<MapTemplateBean> list = new ArrayList<MapTemplateBean>(items.size());
        for (Map.Entry<String, String> entry : items) {
            list.add(new MapTemplateBean(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    protected Collection<String> iFilesToProjectRelativeStrings(Collection<? extends IResource> files) {
        ArrayList<String> strings = new ArrayList<String>();
        for (IResource iResource : files) {
            strings.add(iResource.getProjectRelativePath().toPortableString());
        }
        return strings;
    }

    public static class MapTemplateBean
    extends TemplateBeanAdapter {
        private String key;
        private String value;

        public MapTemplateBean(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

