/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.sun.ToolsJARLocator;
import oracle.eclipse.tools.weblogic.WlsRuntimeClassLoader;
import oracle.eclipse.tools.webservices.JAXVersion;
import oracle.eclipse.tools.webservices.WebServiceProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class CommonWebServiceAntTaskArguments {
    private IFile antscript;
    private IProject project;
    private WebServiceType type;
    private TypeFamily family;
    private String packageName;
    private boolean generateAntScript;
    private boolean executeAnt;
    private String classesDir;
    private final List<IFile> bindings = new ArrayList<IFile>();

    public IProject getProject() {
        return this.project;
    }

    public IFile getAntScript() {
        return this.generateAntScript ? this.antscript : null;
    }

    public void setAntScript(IFile antscript) {
        this.antscript = antscript;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean getGenerateAntScript() {
        return this.generateAntScript;
    }

    public void setGenerateAntScript(boolean generateAntScript) {
        this.generateAntScript = generateAntScript;
    }

    public void setExecuteAnt(boolean execute) {
        this.executeAnt = execute;
    }

    public boolean getExecuteAnt() {
        return this.executeAnt;
    }

    public List<IFile> getBindings() {
        return this.bindings;
    }

    public void clearBindingFiles() {
        this.bindings.clear();
    }

    public final void addBindingFile(IFile binding) {
        if (binding != null && !this.bindings.contains(binding)) {
            this.bindings.add(binding);
        }
    }

    public void removeBindingFile(IFile item) {
        this.bindings.remove(item);
    }

    public final void setBindings(List<IFile> files) {
        this.clearBindingFiles();
        if (files != null && !files.isEmpty()) {
            for (IFile file : files) {
                if (file == null) continue;
                this.addBindingFile(file);
            }
        }
    }

    public boolean shouldInsertClasspath() {
        return this.getBindings().size() > 0 && this.classesDir != null;
    }

    public String initClassesDir() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath path = javaProject.getOutputLocation();
            IFolder classes = javaProject.getProject().getWorkspace().getRoot().getFolder(path);
            return classes == null ? null : classes.getProjectRelativePath().toPortableString();
        }
        catch (JavaModelException mEx) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)mEx));
            return null;
        }
    }

    public String getClassesDir() {
        return this.classesDir;
    }

    public String getWebServiceTypeAsString() {
        return this.type != null ? this.type.name() : null;
    }

    public WebServiceType getWebServiceType() {
        return this.type;
    }

    public String getTypeFamilyAsString() {
        return this.family != null ? this.family.name() : null;
    }

    public TypeFamily getTypeFamily() {
        return this.family;
    }

    public void setTypeFamily(TypeFamily family) {
        this.family = family;
    }

    protected void setProject(IProject project) {
        this.project = project;
        this.type = WebServiceType.valueOf(this.project);
        this.classesDir = this.initClassesDir();
    }

    public URL[] getRuntimeClasspath() {
        WlsRuntimeClassLoader builder = (WlsRuntimeClassLoader)this.getProject().getAdapter(WlsRuntimeClassLoader.class);
        return builder.getURLs();
    }

    public URL[] getToolsRuntimeClasspath() throws MalformedURLException {
        URL[] urls = this.getRuntimeClasspath();
        ArrayList<URL> urlList = new ArrayList<URL>();
        File toolsJARLocation = ToolsJARLocator.findToolsJAR((File)WebServiceProject.getJavaHomeFile(this.project));
        if (toolsJARLocation != null) {
            urlList.add(toolsJARLocation.toURI().toURL());
        }
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            urlList.add(url);
            ++n2;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static enum TypeFamily {
        JAXB(WebServiceType.JAXWS);

        private final WebServiceType validType;

        private TypeFamily(WebServiceType validType) {
            this.validType = validType;
        }

        public boolean isValidType(WebServiceType type) {
            return type == this.validType;
        }
    }

    public static enum WebServiceType {
        JAXWS(JAXVersion.JAX_WS);

        private final JAXVersion version;

        private WebServiceType(JAXVersion version) {
            this.version = version;
        }

        public static WebServiceType valueOf(String string) {
            return Enum.valueOf(WebServiceType.class, string);
        }
    }
}

