/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.glassfish.ant;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.glassfish.ant.OepeAdminTask;
import oracle.eclipse.tools.adf.glassfish.ant.OepeComponent;
import org.apache.tools.ant.BuildException;

public class OepeUndeployTask
extends OepeAdminTask {
    private String action = "undeploy";
    private String name;
    private OepeComponent component;
    private List<OepeComponent> components = new ArrayList<OepeComponent>();

    public OepeUndeployTask() {
        this.setCommand(this.action);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setForce(boolean force) {
        this.addParameter("force", Boolean.toString(force));
    }

    public void setDroptables(boolean droptables) {
        this.addParameter("droptables", Boolean.toString(droptables));
    }

    public void setCascade(boolean cascade) {
        this.addParameter("cascade", Boolean.toString(cascade));
    }

    public void setKeepreposdir(boolean keepreposdir) {
        this.addParameter("keepreposdir", Boolean.toString(keepreposdir));
    }

    public OepeComponent createComponent() {
        this.component = new OepeComponent();
        this.components.add(this.component);
        return this.component;
    }

    @Override
    public void execute() throws BuildException {
        if (this.components.size() == 0 && this.name == null) {
            this.log("name attribute or component must be specified", 1);
            return;
        }
        if (this.components != null) {
            this.processComponents();
        }
        if (this.name != null) {
            this.addCommandOperand(this.name);
            super.execute();
        }
    }

    private void processComponents() throws BuildException {
        for (OepeComponent comp : this.components) {
            if (comp.name == null) {
                this.log("name attribute must be specified in component to deploy", 1);
                return;
            }
            comp.addCommandOperand(comp.name);
            super.execute(String.valueOf(this.action) + " " + comp.getCommand());
        }
    }
}

