/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.adfdt.debug.common.DebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.runner.DebuggeeData;
import org.eclipse.swt.graphics.Image;

public class Property
extends DebuggeeDataDecorator {
    private final String _expression;
    private final DebuggeeData _value;
    private final String _valueString;
    private final Image _icon;
    private final String _propertyName;

    public Property(String propertyName, DebuggeeData value, String expression) {
        this(propertyName, value, null, expression);
    }

    public Property(String propertyName, DebuggeeData value, Image icon) {
        this(propertyName, value, icon, null);
    }

    public Property(String propertyName, DebuggeeData value, Image icon, String expression) {
        super(value);
        this._value = value;
        this._valueString = this._value != null ? DebuggerEvaluatorUtils.evaluateString(value) : "null";
        this._propertyName = propertyName;
        this._expression = expression;
        this._icon = icon;
    }

    @Override
    public String getShortLabel() {
        return this._propertyName;
    }

    @Override
    public String getLongLabel() {
        return this._valueString;
    }

    public DebuggeeData getValueData() {
        return this._value;
    }

    public String getExpression() {
        return this._expression;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    @Override
    public Image getIcon() {
        return this._icon;
    }

    @Override
    public Object getData() {
        return this.getValueData();
    }
}

