/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.el;

import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIDebuggerEvaluator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIEvalDebuggeeDataInfo;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class ExpressionContentProposalProvider
implements IContentProposalProvider {
    private List<String> proposals = new ArrayList<String>();
    private static final Map<String, String> SCOPE_MAPS = new TreeMap<String, String>();

    static {
        SCOPE_MAPS.put("#{applicationScope}", null);
        SCOPE_MAPS.put("#{sessionScope}", null);
        SCOPE_MAPS.put("#{requestScope}", null);
        SCOPE_MAPS.put("#{pageFlowScope}", null);
        SCOPE_MAPS.put("#{viewScope}", null);
        SCOPE_MAPS.put("#{backingBeanScope}", null);
    }

    public ExpressionContentProposalProvider() {
        this.proposals.addAll(SCOPE_MAPS.keySet());
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents.indexOf("#") == 0) {
            if (position > 0) {
                contents = contents.substring(0, position);
            }
            if (contents.indexOf(46) < 0) {
                return this.getScopeProposal(contents);
            }
            if (contents.indexOf(46) > 0) {
                return this.getPropertyNameProposal(contents);
            }
        }
        return new IContentProposal[0];
    }

    private IContentProposal[] getPropertyNameProposal(String contents) {
        String scopeName = contents.substring(2, contents.indexOf(46, 0));
        String inputPropName = contents.substring(contents.indexOf(46) + 1).trim();
        JDIStackFrame stackFrame = AdfDebugUITools.getAdfStackframe();
        if (stackFrame != null) {
            String elString = "#{" + scopeName + "}";
            String GET_EVALUATOR_OR_CONVERTED_VALUE = "oracle.adfinternal.controller.util.Utils.getEvaluatedOrConvertedValue(\"{0}\",java.lang.String.class,null)";
            JDIDebuggerEvaluator evaluator = new JDIDebuggerEvaluator(stackFrame);
            String expression = MessageFormat.format(GET_EVALUATOR_OR_CONVERTED_VALUE, elString, null);
            JDIEvalDebuggeeDataInfo data = evaluator.evaluate(expression, null);
            JDIObjectValue mapVal = (JDIObjectValue)data.getJDIValue();
            IJavaThread thread = (IJavaThread)stackFrame.getThread();
            IJavaValue keySet = this.callMethod(thread, mapVal, "keySet");
            if (keySet != null) {
                try {
                    JDIArrayValue names = (JDIArrayValue)this.callMethod(thread, (JDIObjectValue)keySet, "toArray");
                    TreeSet<String> vals = new TreeSet<String>();
                    IJavaValue[] iJavaValueArray = names.getValues();
                    int n = iJavaValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaValue v = iJavaValueArray[n2];
                        String str = v.toString();
                        String propName = str.substring(1, str.length() - 1);
                        if (inputPropName.length() == 0 || propName.startsWith(inputPropName)) {
                            vals.add("#{" + scopeName + "." + propName + "}");
                        }
                        ++n2;
                    }
                    this.setProposals(vals.toArray(new String[vals.size()]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        int i = 0;
        while (i < this.proposals.size()) {
            String prop = this.proposals.get(i);
            prop = prop.substring(0, prop.length() - 1);
            if (contents.indexOf(46) > 0) {
                contents = contents.substring(0, contents.indexOf(46));
            }
            if (prop.indexOf(contents) == 0) {
                list.add(new ContentProposal(this.proposals.get(i)));
            }
            ++i;
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    private IContentProposal[] getScopeProposal(String contents) {
        if (AdfDebugUITools.getAdfStackframe() == null) {
            return new IContentProposal[0];
        }
        this.setProposals(SCOPE_MAPS.keySet().toArray(new String[0]));
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        int i = 0;
        while (i < this.proposals.size()) {
            String prop = this.proposals.get(i).substring(0, this.proposals.get(i).length());
            if (prop.indexOf(contents) == 0) {
                String scope = this.proposals.get(i);
                list.add(new ContentProposal(scope, scope, null, scope.length() - 1));
            }
            ++i;
        }
        return list.toArray(new IContentProposal[list.size()]);
    }

    private IJavaValue callMethod(IJavaThread thread, JDIObjectValue obj, String methodName) {
        try {
            JDIType jdiType;
            ReferenceType clzType;
            List<Method> methods;
            if (obj != null && (methods = (clzType = (ReferenceType)(jdiType = (JDIType)obj.getJavaType()).getUnderlyingType()).methodsByName(methodName)).size() > 0) {
                Method method = methods.get(0);
                return obj.sendMessage(method.name(), method.signature(), new IJavaValue[0], thread, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setProposals(String[] items) {
        this.proposals.clear();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.proposals.add(s);
            ++n2;
        }
    }
}

