/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adf.share.dt.debug.AdfcDebugArb;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.TypeColumn;
import oracle.adf.share.dt.debug.ViewPortElement;
import oracle.adfdt.debug.common.DeclaredFieldsElementFactory;
import oracle.adfdt.debug.common.ExceptionElementFactory;
import oracle.adfdt.debug.scope.ScopeElementFactory;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DefaultDataContentProvider;
import oracle.ide.Context;
import oracle.ide.model.DataColumn;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

public class ViewPortDataContentProvider
extends DefaultDataContentProvider {
    private static final String GET_VIEW_PORT_CONTEXT_DEBUG_DETAIL = "oracle.adfinternal.controller.debug.DebugFacadeImpl.getViewPortContextDebugDetail(\"{0}\")";
    private static final String VIEW_PORT_ID_FIELD = "viewPortId";
    private static final String CLIENT_ID_FIELD = "clientId";
    private static final String INITIAL_TASK_FLOW_ID_FIELD = "initialTaskFlowId";
    private static final String CURRENT_TASK_FLOW_ID_FIELD = "currentTaskFlowId";
    private static final String VIEW_ACTIVITY_ID_FIELD = "viewActivityId";
    private static final String SUBMITTED_ACTIVITY_ID_FIELD = "submittedActivityId";
    private static final String FINAL_ACTIVITY_ID_FIELD = "finalActivityId";
    private static final String BOOKMARK_REDIRECT_OUTSTANDING_FIELD = "bookmarkRedirectOutstanding";
    private static final String VIEW_SCOPE_FIELD = "viewScope";
    private static final String EXCEPTION_FIELD = "exception";
    private static final String VIEW_PORT_ID_SHORT_LABEL = AdfcDebugArb.VIEW_PORT_ID_SHORT_LABEL;
    private static final String CLIENT_ID_SHORT_LABEL = AdfcDebugArb.CLIENT_ID_SHORT_LABEL;
    private static final String INITIAL_TASK_FLOW_ID_SHORT_LABEL = AdfcDebugArb.INITIAL_TASK_FLOW_ID_SHORT_LABEL;
    private static final String CURRENT_TASK_FLOW_ID_SHORT_LABEL = AdfcDebugArb.CURRENT_TASK_FLOW_ID_SHORT_LABEL;
    private static final String VIEW_ACTIVITY_ID_SHORT_LABEL = AdfcDebugArb.VIEW_ACTIVITY_ID_SHORT_LABEL;
    private static final String SUBMITTED_ACTIVITY_ID_SHORT_LABEL = AdfcDebugArb.SUBMITTED_ACTIVITY_ID_SHORT_LABEL;
    private static final String FINAL_ACTIVITY_ID_SHORT_LABEL = AdfcDebugArb.FINAL_ACTIVITY_ID_SHORT_LABEL;
    private static final String BOOKMARK_REDIRECT_OUTSTANDING_SHORT_LABEL = AdfcDebugArb.BOOKMARK_REDIRECT_OUTSTANDING_SHORT_LABEL;
    private static final String VIEW_SCOPE_SHORT_LABEL = AdfcDebugArb.VIEW_SCOPE_SHORT_LABEL;
    private static final String EXCEPTION_SHORT_LABEL = AdfcDebugArb.EXCEPTION_SHORT_LABEL;
    private static final DeclaredFieldsElementFactory DECLARED_FIELDS_ELEMENT_FACTORY = new DeclaredFieldsElementFactory();
    private static final DataColumn TYPE_COLUMN;
    private static final List<DataColumn> ADDITIONAL_COLUMNS;

    static {
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(VIEW_PORT_ID_FIELD, VIEW_PORT_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(CLIENT_ID_FIELD, CLIENT_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(INITIAL_TASK_FLOW_ID_FIELD, INITIAL_TASK_FLOW_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(CURRENT_TASK_FLOW_ID_FIELD, CURRENT_TASK_FLOW_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(VIEW_ACTIVITY_ID_FIELD, VIEW_ACTIVITY_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(SUBMITTED_ACTIVITY_ID_FIELD, SUBMITTED_ACTIVITY_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(FINAL_ACTIVITY_ID_FIELD, FINAL_ACTIVITY_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(BOOKMARK_REDIRECT_OUTSTANDING_FIELD, BOOKMARK_REDIRECT_OUTSTANDING_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(VIEW_SCOPE_FIELD, new ScopeElementFactory(VIEW_SCOPE_SHORT_LABEL, false));
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(EXCEPTION_FIELD, new ExceptionElementFactory(EXCEPTION_SHORT_LABEL));
        TYPE_COLUMN = new TypeColumn();
        ADDITIONAL_COLUMNS = Collections.singletonList(TYPE_COLUMN);
    }

    @Override
    public List<Element> getChildren(Element structureElement, Element parentElement, Context context, DebuggerEvaluator evaluator) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        if (structureElement instanceof ViewPortElement && parentElement instanceof DataRootElement) {
            ViewPortElement viewPortElement = (ViewPortElement)structureElement;
            String viewPortId = viewPortElement.getViewPortId();
            DebuggeeData viewPortDebugDetailAsDebuggeeData = evaluator.evaluate(MessageFormat.format(GET_VIEW_PORT_CONTEXT_DEBUG_DETAIL, viewPortId), null);
            List<Element> children = DECLARED_FIELDS_ELEMENT_FACTORY.createElements(context, evaluator, viewPortDebugDetailAsDebuggeeData);
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean includeValueColumn(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return structureElement instanceof ViewPortElement;
    }

    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof ViewPortElement) {
            return ADDITIONAL_COLUMNS;
        }
        return Collections.EMPTY_LIST;
    }
}

