/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adf.share.dt.debug.AdfcDebugArb;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.TypeColumn;
import oracle.adfdt.controller.adfc.debug.pageflowstack.PageFlowStackEntryElement;
import oracle.adfdt.debug.common.DeclaredFieldsElementFactory;
import oracle.adfdt.debug.scope.ScopeElement;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.Context;
import oracle.ide.model.DataColumn;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

class PageFlowStackEntryDataContentProvider {
    private static final String GET_PAGE_FLOW_STACK_ENTRY_DEBUG_DETAIL = "oracle.adfinternal.controller.debug.DebugFacadeImpl.getPageFlowStackEntryDebugDetail(\"{0}\", {1})";
    private static final String TASK_FLOW_ID_FIELD = "taskFlowId";
    private static final String TASK_FLOW_CALL_ACTIVITY_ID_FIELD = "taskFlowCallActivityId";
    private static final String CALLING_VIEW_ACTIVITY_ID_FIELD = "callingViewActivityId";
    private static final String VIEW_REACHED_FIELD = "viewReached";
    private static final String TRANSACTION_STARTED_FIELD = "transactionStarted";
    private static final String TRANSACTION_SHARED_FIELD = "transactionShared";
    private static final String DATA_CONTROL_FRAME_CREATED_FIELD = "dataControlFrameCreated";
    private static final String DATA_CONTROL_FRAME_FIELD = "dataControlFrame";
    private static final String TRAIN_MODEL_FIELD = "trainModel";
    private static final String REMOTE_TASK_FLOW_CALL_FIELD = "remoteTaskFlowCall";
    private static final String RETURN_URL_FIELD = "returnUrl";
    private static final String PAGE_FLOW_SCOPE_FIELD = "pageFlowScope";
    private static final String PAGE_FLOW_INPUT_PARAMETERS = "inputParameters";
    private static final String TASK_FLOW_ID_SHORT_LABEL = AdfcDebugArb.TASK_FLOW_ID_SHORT_LABEL;
    private static final String TASK_FLOW_CALL_ACTIVITY_ID_SHORT_LABEL = AdfcDebugArb.TASK_FLOW_CALL_ACTIVITY_ID_SHORT_LABEL;
    private static final String CALLING_VIEW_ACTIVITY_ID_SHORT_LABEL = AdfcDebugArb.CALLING_VIEW_ACTIVITY_ID_SHORT_LABEL;
    private static final String VIEW_REACHED_SHORT_LABEL = AdfcDebugArb.VIEW_REACHED_SHORT_LABEL;
    private static final String TRANSACTION_STARTED_SHORT_LABEL = AdfcDebugArb.TRANSACTION_STARTED_SHORT_LABEL;
    private static final String TRANSACTION_SHARED_SHORT_LABEL = AdfcDebugArb.TRANSACTION_SHARED_SHORT_LABEL;
    private static final String DATA_CONTROL_FRAME_CREATED_SHORT_LABEL = AdfcDebugArb.DATA_CONTROL_FRAME_CREATED_SHORT_LABEL;
    private static final String DATA_CONTROL_FRAME_SHORT_LABEL = AdfcDebugArb.DATA_CONTROL_FRAME_SHORT_LABEL;
    private static final String TRAIN_MODEL_SHORT_LABEL = AdfcDebugArb.TRAIN_MODEL_SHORT_LABEL;
    private static final String REMOTE_TASK_FLOW_CALL_SHORT_LABEL = AdfcDebugArb.REMOTE_TASK_FLOW_CALL_SHORT_LABEL;
    private static final String RETURN_URL_SHORT_LABEL = AdfcDebugArb.RETURN_URL_SHORT_LABEL;
    private static final DeclaredFieldsElementFactory DECLARED_FIELDS_ELEMENT_FACTORY = new DeclaredFieldsElementFactory();
    private static final String PAGE_FLOW_SCOPE_SHORT_LABEL;
    private static final String PAGE_FLOW_INPUT_PARAM_LABEL;
    private static final DataColumn TYPE_COLUMN;
    private static final List<DataColumn> ADDITIONAL_COLUMNS;

    static {
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(TASK_FLOW_ID_FIELD, TASK_FLOW_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(TASK_FLOW_CALL_ACTIVITY_ID_FIELD, TASK_FLOW_CALL_ACTIVITY_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(CALLING_VIEW_ACTIVITY_ID_FIELD, CALLING_VIEW_ACTIVITY_ID_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(VIEW_REACHED_FIELD, VIEW_REACHED_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(TRANSACTION_STARTED_FIELD, TRANSACTION_STARTED_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(TRANSACTION_SHARED_FIELD, TRANSACTION_SHARED_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(DATA_CONTROL_FRAME_CREATED_FIELD, DATA_CONTROL_FRAME_CREATED_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(DATA_CONTROL_FRAME_FIELD, DATA_CONTROL_FRAME_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(TRAIN_MODEL_FIELD, TRAIN_MODEL_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(REMOTE_TASK_FLOW_CALL_FIELD, REMOTE_TASK_FLOW_CALL_SHORT_LABEL);
        DECLARED_FIELDS_ELEMENT_FACTORY.putElementFactory(RETURN_URL_FIELD, RETURN_URL_SHORT_LABEL);
        PAGE_FLOW_SCOPE_SHORT_LABEL = AdfcDebugArb.PAGE_FLOW_SCOPE_SHORT_LABEL;
        PAGE_FLOW_INPUT_PARAM_LABEL = AdfcDebugArb.PAGE_FLOW_INPUT_PARAM_LABEL;
        TYPE_COLUMN = new TypeColumn();
        ADDITIONAL_COLUMNS = Collections.singletonList(TYPE_COLUMN);
    }

    PageFlowStackEntryDataContentProvider() {
    }

    public List<Element> getChildren(Element structureElement, Element parentElement, Context context, DebuggerEvaluator evaluator) {
        if (parentElement instanceof DataRootElement && structureElement instanceof PageFlowStackEntryElement) {
            AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
            PageFlowStackEntryElement pageFlowStackEntryElement = (PageFlowStackEntryElement)structureElement;
            String viewPortId = pageFlowStackEntryElement.getViewPortId();
            int pageFlowStackIndex = pageFlowStackEntryElement.getPageFlowStackIndex();
            DebuggeeData pageFlowStackEntryDebugDetailAsDebuggeeData = evaluator.evaluate(MessageFormat.format(GET_PAGE_FLOW_STACK_ENTRY_DEBUG_DETAIL, viewPortId, pageFlowStackIndex), null);
            List<Element> children = DECLARED_FIELDS_ELEMENT_FACTORY.createElements(context, evaluator, pageFlowStackEntryDebugDetailAsDebuggeeData);
            DebuggeeData pageFlowScopeAsDebuggeeData = pageFlowStackEntryDebugDetailAsDebuggeeData.getField(PAGE_FLOW_SCOPE_FIELD);
            if (pageFlowScopeAsDebuggeeData != null) {
                int pageFlowScopeSize = DebuggerEvaluatorUtils.evaluateCollectionSize(evaluator, pageFlowScopeAsDebuggeeData);
                ScopeElement pageFlowScopeElement = new ScopeElement(PAGE_FLOW_SCOPE_SHORT_LABEL, pageFlowScopeAsDebuggeeData, pageFlowScopeSize, false);
                children.add(pageFlowScopeElement);
            }
            DebuggeeData pageInputParametersAsDebuggeeData = pageFlowStackEntryDebugDetailAsDebuggeeData.getField(PAGE_FLOW_INPUT_PARAMETERS);
            if (pageFlowScopeAsDebuggeeData != null) {
                int paramSize = DebuggerEvaluatorUtils.evaluateCollectionSize(evaluator, pageInputParametersAsDebuggeeData);
                ScopeElement pageFlowScopeElement = new ScopeElement(PAGE_FLOW_INPUT_PARAM_LABEL, pageInputParametersAsDebuggeeData, paramSize, false);
                children.add(pageFlowScopeElement);
            }
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean includeValueColumn(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return structureElement instanceof PageFlowStackEntryElement;
    }

    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof PageFlowStackEntryElement) {
            return ADDITIONAL_COLUMNS;
        }
        return Collections.EMPTY_LIST;
    }
}

