/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggeeDataInfo;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIValueDebuggeeDataInfo
extends DebuggeeDataInfo {
    JDIStackFrame jdiStackFrame = null;
    JDIValueDebuggeeDataInfo parent = null;
    JDIValue jdiValueObj = null;
    IJavaType javaType = null;
    String fieldName = null;
    List<JDIValueDebuggeeDataInfo> declaredFields = null;

    public JDIValueDebuggeeDataInfo(JDIValueDebuggeeDataInfo parent, JDIValue val) {
        super(parent);
        if (parent != null) {
            this.parent = parent;
            this.jdiStackFrame = parent.getJDIStackFrame();
            this.jdiValueObj = val;
            if (val != null) {
                try {
                    this.javaType = this.jdiValueObj.getJavaType();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getFullyQualifiedActualType() {
        if (this.javaType != null) {
            try {
                return this.javaType.getName();
            }
            catch (DebugException debugException) {}
        }
        return "";
    }

    @Override
    public String getActualType() {
        return this.getFullyQualifiedActualType();
    }

    @Override
    public String getDeclaredType() {
        return super.getDeclaredType();
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JDIValue getJDIValue() {
        return this.jdiValueObj;
    }

    public JDIStackFrame getJDIStackFrame() {
        return this.jdiStackFrame;
    }

    @Override
    public List<? extends DebuggeeData> getDeclaredFields() {
        if (this.declaredFields != null) {
            return this.declaredFields;
        }
        this.declaredFields = new ArrayList<JDIValueDebuggeeDataInfo>();
        try {
            if (this.javaType != null) {
                String[] fieldNames;
                String[] stringArray = fieldNames = ((IJavaClassType)this.javaType).getAllFieldNames();
                int n = fieldNames.length;
                int n2 = 0;
                while (n2 < n) {
                    JDIObjectValue jdiObj;
                    IJavaFieldVariable fieldVal;
                    String s = stringArray[n2];
                    if (this.jdiValueObj instanceof JDIObjectValue && (fieldVal = (jdiObj = (JDIObjectValue)this.jdiValueObj).getField(s, false)) != null) {
                        IValue val = fieldVal.getValue();
                        JDIValueDebuggeeDataInfo info = new JDIValueDebuggeeDataInfo(this, (JDIValue)val);
                        info.setFieldName(s);
                        this.declaredFields.add(info);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.declaredFields;
    }

    @Override
    public DebuggeeData getField(String name) {
        this.getDeclaredFields();
        for (JDIValueDebuggeeDataInfo f : this.declaredFields) {
            if (!name.equals(f.fieldName)) continue;
            return f;
        }
        return null;
    }

    @Override
    public String getShortLabel() {
        if (this.fieldName != null) {
            return this.fieldName;
        }
        if (this.jdiValueObj == null) {
            return "";
        }
        return this.jdiValueObj.toString();
    }

    @Override
    public String getLongLabel() {
        try {
            if (this.jdiValueObj != null) {
                String ret = this.jdiValueObj.getValueString();
                return ret;
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return "1";
    }

    protected IJavaType getJavaType(String typeName) throws DebugException {
        if (this.jdiStackFrame == null) {
            return null;
        }
        IJavaThread thread = (IJavaThread)this.jdiStackFrame.getThread();
        JDIDebugTarget jdiTarget = (JDIDebugTarget)thread.getDebugTarget();
        IJavaType[] types = jdiTarget.getJavaTypes(typeName);
        if (types != null && types.length > 0) {
            IJavaType type = types[0];
            return type;
        }
        return null;
    }

    @Override
    public List<? extends DebuggeeData> getChildren() {
        ArrayList<JDIValueDebuggeeDataInfo> ret = new ArrayList<JDIValueDebuggeeDataInfo>();
        try {
            if (this.jdiValueObj instanceof JDIArrayValue) {
                JDIArrayValue arrayVal = (JDIArrayValue)this.jdiValueObj;
                IJavaValue[] iJavaValueArray = arrayVal.getValues();
                int n = iJavaValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaValue v = iJavaValueArray[n2];
                    JDIValueDebuggeeDataInfo c = new JDIValueDebuggeeDataInfo(this, (JDIValue)v);
                    ret.add(c);
                    ++n2;
                }
                return ret;
            }
            JDIObjectValue obj = (JDIObjectValue)this.jdiValueObj;
            if (obj != null && !(obj instanceof JDINullValue)) {
                IJavaThread thread = (IJavaThread)this.jdiStackFrame.getThread();
                JDIType jdiType = (JDIType)obj.getJavaType();
                ReferenceType clzType = (ReferenceType)jdiType.getUnderlyingType();
                List<Method> methods = clzType.methodsByName("toArray");
                if (methods.size() > 0) {
                    Method method = methods.get(0);
                    JDIArrayValue arrayVal = (JDIArrayValue)obj.sendMessage(method.name(), method.signature(), new IJavaValue[0], thread, true);
                    IJavaValue[] iJavaValueArray = arrayVal.getValues();
                    int n = iJavaValueArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IJavaValue v = iJavaValueArray[n3];
                        JDIValueDebuggeeDataInfo c = new JDIValueDebuggeeDataInfo(this, (JDIValue)v);
                        ret.add(c);
                        ++n3;
                    }
                }
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public IJavaType getReturnJavaType() {
        return this.javaType;
    }

    public void setReturnJavaType(IJavaType type) {
        this.javaType = type;
    }
}

