/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.List;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebuggerUiPlugin;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIValueDebuggeeDataInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIClassType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIEvalDebuggeeDataInfo
extends JDIValueDebuggeeDataInfo {
    String expression;
    String callingMethodName;
    String inputFieldName;
    IJavaType inputJavaType;

    public JDIEvalDebuggeeDataInfo(JDIValueDebuggeeDataInfo parent, String expression, JDIStackFrame jdiStackFrame) {
        block9: {
            int n;
            super(parent, null);
            this.expression = null;
            this.callingMethodName = null;
            this.inputFieldName = null;
            this.inputJavaType = null;
            if (parent == null) {
                this.jdiStackFrame = jdiStackFrame;
            }
            this.expression = expression;
            int n1 = expression.indexOf(40);
            String expression2 = expression;
            if (n1 > 0) {
                expression2 = expression.substring(0, n1);
            }
            if ((n = expression2.lastIndexOf(46)) > 0) {
                try {
                    String inputTypeName = expression.substring(0, n);
                    this.inputJavaType = this.getJavaType(inputTypeName);
                    if (expression.indexOf(40) > 0) {
                        this.callingMethodName = expression.substring(n + 1);
                        break block9;
                    }
                    this.inputFieldName = expression.substring(n + 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.inputJavaType = parent.javaType;
                if (expression.indexOf(40) > 0) {
                    this.callingMethodName = expression;
                } else {
                    this.inputFieldName = expression;
                }
            }
        }
    }

    public void evaluate() {
        block15: {
            try {
                JDIValue jdiObjVal;
                block16: {
                    IJavaThread thread = (IJavaThread)this.jdiStackFrame.getThread();
                    if (!thread.isSuspended()) {
                        return;
                    }
                    if (this.inputJavaType == null) break block15;
                    if (this.callingMethodName != null) {
                        JDIType jdiType;
                        ReferenceType clzType;
                        List<Method> methods;
                        IJavaValue[] parameters = null;
                        int n = this.callingMethodName.indexOf(40);
                        if (n > 0) {
                            parameters = this.parseParameters(this.callingMethodName);
                            this.callingMethodName = this.callingMethodName.substring(0, n);
                        }
                        if ((methods = (clzType = (ReferenceType)(jdiType = (JDIType)this.inputJavaType).getUnderlyingType()).methodsByName(this.callingMethodName)).size() > 0) {
                            Method method = methods.get(0);
                            String signature = method.signature();
                            if (this.parent == null) {
                                this.jdiValueObj = (JDIObjectValue)((IJavaClassType)this.inputJavaType).sendMessage(this.callingMethodName, signature, parameters, thread);
                            } else {
                                JDIObjectValue obj = (JDIObjectValue)this.parent.jdiValueObj;
                                this.jdiValueObj = (JDIValue)obj.sendMessage(this.callingMethodName, signature, parameters, thread, null);
                            }
                            if (!this.jdiValueObj.isNull()) {
                                this.javaType = this.jdiValueObj.getJavaType();
                            } else {
                                try {
                                    Type retType = method.returnType();
                                    String returnTypeName = retType.name();
                                    this.javaType = this.getJavaType(returnTypeName);
                                }
                                catch (ClassNotLoadedException ce) {
                                    IJavaValue param;
                                    IJavaValue ret;
                                    IJavaClassType type = (IJavaClassType)this.getJavaType("oracle.adf.share.common.ClassUtils");
                                    String className = ce.className();
                                    if (className.charAt(0) == 'L') {
                                        className = className.substring(1);
                                    }
                                    if (AdfDebugUITools.isDebugMode()) {
                                        AdfDebuggerUiPlugin.logInfo("Explicitly loading ADF runtime class " + className, null);
                                    }
                                    if ((ret = type.sendMessage("forName", "(Ljava/lang/String;)Ljava/lang/Class;", new IJavaValue[]{param = this.jdiStackFrame.getJavaDebugTarget().newValue(className)}, thread)) == null) break block16;
                                    this.javaType = this.getJavaType(className);
                                    this.jdiValueObj = (JDIObjectValue)((IJavaClassType)this.inputJavaType).sendMessage(this.callingMethodName, signature, parameters, thread);
                                    if (!AdfDebugUITools.isDebugMode()) break block16;
                                    AdfDebuggerUiPlugin.logInfo("ADF runtime class loaded successfully" + className, null);
                                }
                            }
                        }
                    }
                }
                if (this.inputFieldName != null && (jdiObjVal = this.parent.getJDIValue()) instanceof JDIObjectValue) {
                    IJavaFieldVariable fieldVar = ((JDIObjectValue)jdiObjVal).getField(this.inputFieldName, true);
                    this.jdiValueObj = (JDIValue)fieldVar.getValue();
                }
            }
            catch (Exception e) {
                String msg = "Error evaluating expression in ADFContext: " + this.expression;
                AdfDebuggerUiPlugin.getDefault().getLog().log((IStatus)new Status(2, "oracle.eclipse.tools.adf.debugger.ui", msg, (Throwable)e));
            }
        }
    }

    protected IJavaValue[] parseParameters(String methodName2) {
        String params;
        int n1 = methodName2.indexOf(40);
        int n2 = methodName2.indexOf(41);
        if (n1 > 0 && n2 > 0 && (params = methodName2.substring(n1 + 1, n2)).length() > 0) {
            String[] list = params.split(",");
            IJavaValue[] parameters = new IJavaValue[list.length];
            int n = 0;
            String[] stringArray = list;
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray[n4];
                IJavaDebugTarget javaTarget = (IJavaDebugTarget)this.jdiStackFrame.getDebugTarget();
                if (s.startsWith("\"")) {
                    s = s.substring(1, s.length() - 1);
                    parameters[n] = javaTarget.newValue(s);
                } else if (s.indexOf(".class") > 0) {
                    String typeName = s.substring(0, s.indexOf(".class"));
                    try {
                        JDIClassType type = (JDIClassType)this.getJavaType(typeName.trim());
                        parameters[n] = type.getClassObject();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (s.trim().equals("null")) {
                    parameters[n] = new JDINullValue((JDIDebugTarget)javaTarget);
                } else {
                    Integer intVal = Integer.valueOf(s.trim());
                    parameters[n] = javaTarget.newValue(intVal.intValue());
                }
                ++n;
                ++n4;
            }
            return parameters;
        }
        return null;
    }
}

