/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIDebuggerEvaluator;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public final class DebuggerEvaluatorUtils {
    private static JDIDebuggerEvaluator jdiEvaluator = null;
    private static final String NULL_STRING_REPRESENTATION = "null";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String OBJECT_TO_STRING = "toString()";
    private static final String COLLECTION_TO_ARRAY = "toArray()";
    private static final String COLLECTION_SIZE = "size()";
    private static final String MAP_ENTRY_SET = "entrySet()";
    private static final String MAP_ENTRY_GET_KEY = "getKey()";
    private static final String MAP_ENTRY_GET_VALUE = "getValue()";
    private static final List<String> MAP_ENTRY_GET_KEY_AND_VALUE = Arrays.asList("getKey()", "getValue()");

    public static DebuggerEvaluator getDebuggerEvaluator() {
        if (jdiEvaluator != null && DebuggerEvaluatorUtils.jdiEvaluator.jdiStackFrame != null) {
            if (!DebuggerEvaluatorUtils.jdiEvaluator.jdiStackFrame.getThread().isSuspended()) {
                jdiEvaluator = null;
            }
            return jdiEvaluator;
        }
        return null;
    }

    public static void setStackFrame(JDIStackFrame jdiStackframe) {
        if (jdiEvaluator == null) {
            jdiEvaluator = new JDIDebuggerEvaluator(jdiStackframe);
        } else if (jdiEvaluator.getStackFrame() != jdiStackframe) {
            jdiEvaluator.setStackFram(jdiStackframe);
        }
    }

    public static void resetDebuggerEvaluator() {
        jdiEvaluator = null;
    }

    private DebuggerEvaluatorUtils() {
    }

    public static boolean evaluateIsNull(DebuggeeData objectAsDebuggeeData) {
        if (objectAsDebuggeeData != null) {
            String longLabel = objectAsDebuggeeData.getLongLabel();
            return NULL_STRING_REPRESENTATION.equals(longLabel);
        }
        return true;
    }

    public static String evaluateToString(DebuggerEvaluator evaluator, DebuggeeData objectAsDebuggeeData) {
        DebuggeeData stringAsDebuggeeData = evaluator.evaluate(OBJECT_TO_STRING, objectAsDebuggeeData);
        if (stringAsDebuggeeData != null) {
            return DebuggerEvaluatorUtils.evaluateString(stringAsDebuggeeData);
        }
        return null;
    }

    public static boolean evaluateBoolean(DebuggeeData booleanAsDebuggeeData) {
        if (booleanAsDebuggeeData != null) {
            String longLabel = booleanAsDebuggeeData.getLongLabel();
            return Boolean.parseBoolean(longLabel);
        }
        return false;
    }

    public static int evaluateInt(DebuggeeData intAsDebuggeeData) {
        if (intAsDebuggeeData != null) {
            String longLabel = intAsDebuggeeData.getLongLabel();
            return Integer.parseInt(longLabel);
        }
        return -1;
    }

    public static String evaluateString(DebuggeeData stringAsDebuggeeData) {
        if (!DebuggerEvaluatorUtils.evaluateIsNull(stringAsDebuggeeData)) {
            String longLabel = stringAsDebuggeeData.getLongLabel();
            int longLabelLength = longLabel.length();
            int start = longLabel.startsWith(DOUBLE_QUOTE) && longLabelLength > 0 ? 1 : 0;
            int end = longLabel.endsWith(DOUBLE_QUOTE) && longLabelLength > 0 ? longLabelLength - 1 : longLabelLength;
            return longLabel.substring(start, end);
        }
        return null;
    }

    public static List<DebuggeeData> evaluateCollection(DebuggerEvaluator evaluator, DebuggeeData collectionAsDebuggeeData) {
        List<? extends DebuggeeData> children;
        LinkedList<DebuggeeData> result = new LinkedList<DebuggeeData>();
        DebuggeeData arrayAsDebuggeeData = evaluator.evaluate(COLLECTION_TO_ARRAY, collectionAsDebuggeeData);
        if (arrayAsDebuggeeData != null && (children = arrayAsDebuggeeData.getChildren()) != null) {
            result.addAll(children);
        }
        return result;
    }

    public static int evaluateCollectionSize(DebuggerEvaluator evaluator, DebuggeeData collectionAsDebuggeeData) {
        DebuggeeData sizeAsDebuggeeData = evaluator.evaluate(COLLECTION_SIZE, collectionAsDebuggeeData);
        if (sizeAsDebuggeeData != null) {
            int size = DebuggerEvaluatorUtils.evaluateInt(sizeAsDebuggeeData);
            return size;
        }
        return -1;
    }

    public static Map<DebuggeeData, DebuggeeData> evaluateMap(DebuggerEvaluator evaluator, DebuggeeData mapAsDebuggeeData) {
        HashMap<DebuggeeData, DebuggeeData> result = new HashMap<DebuggeeData, DebuggeeData>();
        DebuggeeData mapEntriesArrayAsDebuggeeData = evaluator.evaluate(MAP_ENTRY_SET, mapAsDebuggeeData);
        if (mapEntriesArrayAsDebuggeeData != null) {
            List<? extends DebuggeeData> mapEntriesAsDebuggeeData = mapEntriesArrayAsDebuggeeData.getChildren();
            for (DebuggeeData debuggeeData : mapEntriesAsDebuggeeData) {
                List<DebuggeeData> keyAndValueAsDebuggeeData = evaluator.evaluate(MAP_ENTRY_GET_KEY_AND_VALUE, debuggeeData);
                DebuggeeData keyAsDebuggeeData = keyAndValueAsDebuggeeData.get(0);
                DebuggeeData valueAsDebuggeeData = keyAndValueAsDebuggeeData.get(1);
                result.put(keyAsDebuggeeData, valueAsDebuggeeData);
            }
        }
        return result;
    }
}

