/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adf.share.dt.debug.BaseView;
import oracle.adf.share.dt.debug.ComponentInfo;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.JspViewContext;
import oracle.adf.share.dt.debug.PropertyInfo;
import oracle.adf.share.dt.debug.TypeColumn;
import oracle.adfdt.debug.common.DebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DefaultDataContentProvider;
import oracle.ide.Context;
import oracle.ide.model.Component;
import oracle.ide.model.DataColumn;
import oracle.ide.model.Element;
import oracle.ide.model.ExpressionDataColumn;
import oracle.ide.model.Property;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

class AdfViewDataContentProvider
extends DefaultDataContentProvider {
    AdfViewDataContentProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Element> getChildren(Element structureElement, Element parentElement, Context context, DebuggerEvaluator evaluator) {
        if (!(structureElement instanceof BaseView)) {
            return Collections.EMPTY_LIST;
        }
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        BaseView view = (BaseView)structureElement;
        if (parentElement instanceof DataRootElement) {
            ComponentInfo rootComponent = view.getViewRoot(evaluator);
            if (rootComponent == null) {
                return Collections.EMPTY_LIST;
            }
            JspViewContext jvContext = view.getJspViewContext(context);
            if (view.isRootComponentRelevant()) {
                return Collections.singletonList(new Component(jvContext, rootComponent));
            }
            ArrayList<Element> ret = new ArrayList<Element>();
            List<ComponentInfo> components = rootComponent.getComponents();
            if (components != null) {
                for (ComponentInfo componentInfo : components) {
                    ret.add(new Component(jvContext, componentInfo));
                }
            }
            return ret;
        }
        if (parentElement instanceof Component) {
            void var10_23;
            Component component = (Component)parentElement;
            ComponentInfo componentInfo = component.getComponentInfo();
            ArrayList<Element> ret = new ArrayList<Element>();
            ret.add(new DebuggeeDataDecorator("instance", componentInfo.getComponent()));
            for (PropertyInfo property : componentInfo.getProperties()) {
                DebuggeeData value = property.getValueData();
                String propertyName = property.getName();
                ret.add(new Property(propertyName, value, property.getExpression()));
            }
            DebuggeeData converter = componentInfo.getConverter();
            if (converter != null && !"null".equals(converter.getLongLabel())) {
                ret.add(new Property(converter.getActualType(), converter, OracleIcons.getIcon("BIMM")));
            }
            for (DebuggeeData debuggeeData : componentInfo.getValidators()) {
                ret.add(new Property(debuggeeData.getActualType(), debuggeeData, OracleIcons.getIcon("VALIDATOR")));
            }
            Object var10_20 = null;
            if (!view.isShowingPageTemplateContent() && "oracle.adf.view.rich.component.rich.fragment.RichPageTemplate".equals(componentInfo.getComponentClass())) {
                List<ComponentInfo> list = componentInfo.getSpecialComponents();
            } else {
                List<ComponentInfo> list = componentInfo.getComponents();
            }
            JspViewContext jvContext = view.getJspViewContext(context);
            for (ComponentInfo child : var10_23) {
                ret.add(new Component(jvContext, child));
            }
            return Collections.unmodifiableList(ret);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean includeValueColumn(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return structureElement instanceof BaseView;
    }

    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof BaseView) {
            ArrayList<DataColumn> ret = new ArrayList<DataColumn>();
            ret.add(new ExpressionDataColumn());
            ret.add(TypeColumn.getCommonInstance());
            return ret;
        }
        return Collections.EMPTY_LIST;
    }
}

