/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.AdfContextElement;
import oracle.adf.share.dt.debug.BaseView;
import oracle.adf.share.dt.debug.ChildViewPortElement;
import oracle.adf.share.dt.debug.ComponentInfo;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.JspView;
import oracle.adf.share.dt.debug.JspViewContext;
import oracle.adf.share.dt.debug.ViewPortElement;
import oracle.adfdt.controller.adfc.debug.pageflowstack.PageFlowStackEntryElement;
import oracle.adfdt.debug.scope.ScopeElement;
import oracle.adfdt.model.debug.structure.ApplicationDataElement;
import oracle.adfdt.model.debug.structure.BindingContainerElement;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfContextDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfViewDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.ApplicationDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.BindingContainerDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.eclipse.tools.adf.debugger.ui.views.data.ListDataStackFrameHolder;
import oracle.eclipse.tools.adf.debugger.ui.views.data.MapDataStackFrameHolder;
import oracle.eclipse.tools.adf.debugger.ui.views.data.PageFlowStackEntryDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.ScopesDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.ViewPortDataContentProvider;
import oracle.ide.Context;
import oracle.ide.model.Component;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.jface.viewers.TreePath;

public class AdfDataContentProvider {
    public static final AdfDataContentProvider INSTANCE = new AdfDataContentProvider();
    AdfContextDataContentProvider adfContextDataContentProvider = new AdfContextDataContentProvider();
    ScopesDataContentProvider adfContextScopesDataContentProvider = new ScopesDataContentProvider();
    ViewPortDataContentProvider viewPortDataContentProvider = new ViewPortDataContentProvider();
    AdfViewDataContentProvider adfViewDataContentProvider = new AdfViewDataContentProvider();
    ApplicationDataContentProvider applicationDataContentProvider = new ApplicationDataContentProvider();
    BindingContainerDataContentProvider BindingContainerDataContentProvider = new BindingContainerDataContentProvider();
    PageFlowStackEntryDataContentProvider pageFlowStackEntryDataContentProvider = new PageFlowStackEntryDataContentProvider();

    private AdfDataContentProvider() {
    }

    public Object getDataTableViewerInput(Object inputElement, TreePath[] treePaths) {
        DebuggerEvaluator evaluator = DebuggerEvaluatorUtils.getDebuggerEvaluator();
        if (inputElement instanceof ScopeElement) {
            ScopeElement se = (ScopeElement)inputElement;
            MapDataStackFrameHolder stackFrame = new MapDataStackFrameHolder(se);
            return stackFrame;
        }
        if (inputElement instanceof AdfContextElement) {
            AdfContextElement structureElement = (AdfContextElement)inputElement;
            DataRootElement parentElement = new DataRootElement();
            Context context = new Context();
            List<Element> list = this.adfContextDataContentProvider.getChildren(structureElement, parentElement, context, evaluator);
            if (list.size() > 0) {
                ListDataStackFrameHolder stackFrame = new ListDataStackFrameHolder(list);
                return stackFrame;
            }
        } else if (inputElement instanceof PageFlowStackEntryElement) {
            PageFlowStackEntryElement structureElement = (PageFlowStackEntryElement)inputElement;
            DataRootElement parentElement = new DataRootElement();
            Context context = new Context();
            List<Element> list = this.pageFlowStackEntryDataContentProvider.getChildren(structureElement, parentElement, context, evaluator);
            if (list.size() > 0) {
                ListDataStackFrameHolder stackFrame = new ListDataStackFrameHolder(list);
                return stackFrame;
            }
        } else {
            if (inputElement instanceof ApplicationDataElement) {
                DataRootElement parentElement = new DataRootElement();
                Context context = new Context();
                ApplicationDataElement structureElement = (ApplicationDataElement)inputElement;
                List<Element> list = this.applicationDataContentProvider.getChildren(structureElement, parentElement, context, evaluator);
                ListDataStackFrameHolder stackFrame = new ListDataStackFrameHolder(list);
                return stackFrame;
            }
            if (inputElement instanceof BaseView) {
                List<Element> list;
                TreePath tp;
                JspView jspView;
                List<Component> comps;
                Element parentElement = new DataRootElement();
                Context context = new Context();
                BaseView structureElement = (BaseView)inputElement;
                if (!(structureElement instanceof JspView) && (comps = this.getComponent(jspView = (JspView)(tp = treePaths[0]).getSegment(2), evaluator, context)).size() > 0) {
                    parentElement = comps.get(0);
                }
                if ((list = this.adfViewDataContentProvider.getChildren(structureElement, parentElement, context, evaluator)).size() > 0) {
                    ListDataStackFrameHolder stackFrame = new ListDataStackFrameHolder(list);
                    return stackFrame;
                }
                return new DataRootElement();
            }
            if (inputElement instanceof ViewPortElement) {
                DataRootElement parentElement = new DataRootElement();
                ViewPortElement structureElement = (ViewPortElement)inputElement;
                Context context = new Context();
                List<Element> list = this.viewPortDataContentProvider.getChildren(structureElement, parentElement, context, evaluator);
                ListDataStackFrameHolder stackFrame = new ListDataStackFrameHolder(list);
                return stackFrame;
            }
            if (inputElement instanceof ChildViewPortElement) {
                return new DataRootElement();
            }
            if (inputElement instanceof BindingContainerElement) {
                ArrayList<Element> list = new ArrayList<Element>();
                BindingContainerElement bcElement = (BindingContainerElement)inputElement;
                list.add(bcElement);
                ListDataStackFrameHolder stackFrame = new ListDataStackFrameHolder(list);
                return stackFrame;
            }
        }
        return new DataRootElement();
    }

    private List<Component> getComponent(BaseView view, DebuggerEvaluator evaluator, Context context) {
        ComponentInfo rootComponent = view.getViewRoot(evaluator);
        if (rootComponent == null) {
            return Collections.EMPTY_LIST;
        }
        JspViewContext jvContext = view.getJspViewContext(context);
        if (view.isRootComponentRelevant()) {
            return Collections.singletonList(new Component(jvContext, rootComponent));
        }
        ArrayList<Component> ret = new ArrayList<Component>();
        List<ComponentInfo> components = rootComponent.getComponents();
        if (components != null) {
            for (ComponentInfo child : components) {
                ret.add(new Component(jvContext, child));
            }
        }
        return ret;
    }
}

