/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.preference;

import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebuggerUiPlugin;
import oracle.eclipse.tools.adf.debugger.ui.preference.ADFSourceLocation;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.DirectoryBrowserTextField;
import oracle.eclipse.tools.common.ui.widgets.PropertyTable;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class ADFSourceLocationConfigDialog
extends Dialog {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private ADFSourceLocation sourceLocation = null;
    private DirectoryBrowserTextField location;
    private Label tableLabel;
    private PropertyTable table;
    private Label msglabel;
    private Object msgowner = this;
    private boolean suppressLocationChangedEvents = false;

    public ADFSourceLocationConfigDialog(Shell shell, ADFSourceLocation sourceLocation) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.sourceLocation = sourceLocation;
    }

    public ADFSourceLocation getADFSourceLocation() {
        return this.sourceLocation;
    }

    protected Control createDialogArea(Composite parent) {
        String clname;
        IDialogSettings settings;
        IDialogSettings root = AdfDebuggerUiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings = settings = root.getSection(clname = ((Object)((Object)this)).getClass().getName()) != null ? root.getSection(clname) : root.addNewSection(clname);
        if (settings.get(WIDTH) == null) {
            settings.put(WIDTH, 400);
        }
        if (settings.get(HEIGHT) == null) {
            settings.put(HEIGHT, 200);
        }
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData d0 = SwtUtil.gdfill();
        d0.widthHint = settings.getInt(WIDTH);
        d0.heightHint = settings.getInt(HEIGHT);
        composite.setLayoutData((Object)d0);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = composite.getSize();
                settings.put(ADFSourceLocationConfigDialog.WIDTH, size.x);
                settings.put(ADFSourceLocationConfigDialog.HEIGHT, size.y);
            }
        });
        Label label = new Label(composite, 0);
        label.setText(Resources.locationLabel);
        label.setLayoutData((Object)SwtUtil.gdhfill());
        this.location = new DirectoryBrowserTextField(composite, 0);
        this.location.setLayoutData((Object)SwtUtil.gdhfill());
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ADFSourceLocationConfigDialog.this.locationChanged();
            }
        });
        this.tableLabel = new Label(composite, 0);
        this.tableLabel.setText(Resources.attributesLabel);
        this.tableLabel.setLayoutData((Object)SwtUtil.gdhfill());
        this.table = new PropertyTable(composite);
        this.table.setLayoutData((Object)SwtUtil.gdhfill());
        this.table.defineProperty(Resources.nameProperty);
        this.table.defineProperty(Resources.versionProperty);
        this.table.defineProperty(Resources.descriptionProperty);
        this.msglabel = new Label(composite, 64);
        GridData gd = SwtUtil.gdhfill();
        gd.heightHint = 100;
        this.msglabel.setLayoutData((Object)gd);
        this.msglabel.setForeground(SwtUtil.color((int)3));
        if (this.sourceLocation != null) {
            File f = this.sourceLocation.getLocation();
            this.location.setFile(f);
            BundleInfo info = ADFSourceLocationConfigDialog.getADFSrcBundleInfo(f);
            this.updatePropertiesView(info);
        }
        if (this.location.getFile() != null) {
            this.locationChanged();
        }
        this.update();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.sourceLocation == null) {
            shell.setText(Resources.dialogTitleForAdd);
        } else {
            shell.setText(Resources.dialogTitleForEdit);
        }
    }

    protected void cancelPressed() {
        this.sourceLocation = null;
        super.cancelPressed();
    }

    private void update() {
        this.updateButtonEnablement();
    }

    private void updatePropertiesView(BundleInfo info) {
        if (info != null) {
            this.tableLabel.setEnabled(true);
            this.table.setEnabled(true);
            this.setProperty(Resources.nameProperty, info.name, false, Resources.cannotOverrideValue);
            this.setProperty(Resources.versionProperty, info.version, false, Resources.cannotOverrideValue);
            this.setProperty(Resources.descriptionProperty, info.description, false, Resources.cannotOverrideValue);
        } else {
            this.tableLabel.setEnabled(false);
            this.table.setEnabled(false);
            this.table.setProperty(Resources.nameProperty, null);
            this.table.setProperty(Resources.versionProperty, null);
            this.table.setProperty(Resources.descriptionProperty, null);
        }
    }

    private void updateButtonEnablement() {
        boolean enabled = true;
        if (this.sourceLocation == null) {
            enabled = false;
        }
        this.setOkButtonEnabled(enabled);
    }

    private void setOkButtonEnabled(final boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        } else {
            final Display display = Display.getCurrent();
            Thread t = new Thread(){

                @Override
                public void run() {
                    Button b = ADFSourceLocationConfigDialog.this.getButton(0);
                    while (b == null) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        b = ADFSourceLocationConfigDialog.this.getButton(0);
                    }
                    final Button finalButton = b;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            finalButton.setEnabled(enabled);
                        }
                    });
                }
            };
            t.start();
        }
    }

    private void setProperty(String name, Object value, boolean modifiable, String nonModifiableMsg) {
        this.table.setProperty(name, value == null ? null : value.toString());
        this.table.setModifiable(name, modifiable, nonModifiableMsg);
    }

    private void locationChanged() {
        if (this.suppressLocationChangedEvents) {
            return;
        }
        this.sourceLocation = null;
        BundleInfo info = null;
        File f = this.location.getFile();
        if (f == null) {
            this.displayMessage(Resources.selectFile);
        } else if (!f.isDirectory()) {
            this.displayMessage(Resources.selectValidFile);
        } else {
            info = ADFSourceLocationConfigDialog.getADFSrcBundleInfo(f);
            this.updatePropertiesView(info);
            this.setOkButtonEnabled(info != null);
            if (info == null) {
                File adfControllerSrcDir = new File(String.valueOf(f.getAbsolutePath()) + "/oracle/adf/controller");
                String srcDirName = f.getName();
                if (!adfControllerSrcDir.exists()) {
                    this.displayMessage(Resources.selectValidFile);
                    return;
                }
                String srcVer = this.getAdfSourceVersion(srcDirName);
                if (srcVer == null) {
                    this.displayMessage(Resources.unkownAdfSrcVer);
                    return;
                }
                info = new BundleInfo();
                info.name = "ADF Framework Source";
                info.version = srcVer;
            }
            this.sourceLocation = new ADFSourceLocation(info.version, this.location.getFile());
            this.clearMessage();
        }
        this.updatePropertiesView(info);
        this.update();
    }

    private String getAdfSourceVersion(String srcDirName) {
        if (!srcDirName.startsWith("adf_")) {
            return null;
        }
        String srcVersion = srcDirName.substring("adf_".length());
        try {
            int n = srcVersion.indexOf(95);
            srcVersion = srcVersion.substring(0, n);
            srcVersion = String.valueOf(srcVersion.substring(0, 2)) + "." + srcVersion.charAt(2) + "." + srcVersion.charAt(3) + "." + srcVersion.charAt(4);
        }
        catch (Exception exception) {
            return null;
        }
        return srcVersion;
    }

    public static BundleInfo getADFSrcBundleInfo(File f) {
        File metaInf;
        File bundleXml;
        if (f.exists() && f.isDirectory() && (bundleXml = new File(metaInf = new File(f, "META-INF"), "bundle.xml")).exists()) {
            try {
                String fileContent = FileUtil.readTextFile((File)bundleXml);
                int n = fileContent.indexOf("<name>ADF Framework Source</name>");
                if (n > 0) {
                    BundleInfo info = new BundleInfo();
                    info.name = ADFSourceLocationConfigDialog.getElementValue(fileContent, "name");
                    info.version = ADFSourceLocationConfigDialog.getElementValue(fileContent, "version");
                    info.description = ADFSourceLocationConfigDialog.getElementValue(fileContent, "description");
                    return info;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static String getElementValue(String fileContent, String element) {
        int n1 = fileContent.indexOf("<" + element + ">");
        int n2 = fileContent.indexOf("</" + element + ">");
        String value = fileContent.substring(n1 + element.length() + 2, n2);
        return value;
    }

    private void displayMessage(String msg) {
        if (this.msgowner == this) {
            this.msglabel.setText(msg);
        }
    }

    private void clearMessage() {
        if (this.msgowner == this) {
            this.msglabel.setText("");
        }
    }

    public static class BundleInfo {
        String name;
        String version;
        String description;
    }

    private static final class Resources
    extends NLS {
        public static String locationLabel;
        public static String attributesLabel;
        public static String nameProperty;
        public static String versionProperty;
        public static String descriptionProperty;
        public static String dialogTitleForAdd;
        public static String dialogTitleForEdit;
        public static String selectFile;
        public static String selectValidFile;
        public static String unkownAdfSrcVer;
        public static String cannotOverrideValue;

        static {
            Resources.initializeMessages((String)ADFSourceLocationConfigDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

