/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.diagram;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.lifecycle.AdfLifecycle;
import oracle.eclipse.tools.adf.debugger.lifecycle.AdfLifecyclePhaseBreakpoint;
import oracle.eclipse.tools.adf.debugger.lifecycle.IAdfLifecyclePhaseBreakpoint;
import oracle.eclipse.tools.adf.debugger.lifecycle.Phase;
import oracle.eclipse.tools.adf.debugger.ui.diagram.LifecyclePhaseFigure;
import oracle.eclipse.tools.adf.debugger.ui.diagram.ZoomContainer;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class AdfLifecycleDiagram
implements IBreakpointsListener,
ISelectionProvider {
    private HashMap<String, LifecyclePhaseFigure> adfPhaseFigureMap = new HashMap();
    private LifecyclePhaseFigure currentSelection = null;
    private ScrollPane scrollPane = null;
    private ZoomContainer zoomPanel = null;
    private int zoom = 40;
    private HashMap<String, IAdfLifecyclePhaseBreakpoint> breakPointMap = new HashMap();
    private static final Color LINK_COLOR = new Color(null, 204, 204, 204);
    private static final Color WHITE_COLOR = new Color(null, 255, 255, 255);
    private ListenerList selectionChangedListeners = new ListenerList();

    public Figure getContents() {
        Figure fig = new Figure();
        fig.setBackgroundColor(WHITE_COLOR);
        fig.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.zoomPanel = new ZoomContainer();
        this.zoomPanel.setBorder((Border)new GroupBoxBorder(""));
        this.zoomPanel.setMinimumSize(new Dimension(5, 5));
        this.createDigramContents(this.zoomPanel);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollBarVisibility(1);
        this.scrollPane.setContents((IFigure)this.zoomPanel);
        this.scrollPane.setBackgroundColor(WHITE_COLOR);
        fig.add((IFigure)this.scrollPane);
        this.zoomPanel.setZoom(this.getScale());
        return fig;
    }

    public void dispose() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.removeBreakpointListener((IBreakpointsListener)this);
    }

    float getScale() {
        float s = (float)(this.zoom + 10) * 0.02f;
        return s;
    }

    private void createDigramContents(Figure panel) {
        int leftOffset = 100;
        Figure contents = new Figure();
        contents.setLayoutManager((LayoutManager)new FreeformLayout());
        Label phaseLabel1 = new Label(Resources.jsfLifeCycle);
        Font font = NodeDiagramStyleSheets.getHeaderLabelFont();
        phaseLabel1.setFont(font);
        phaseLabel1.setForegroundColor(NodeDiagramStyleSheets.HEADER_LABEL_COLOR);
        phaseLabel1.setBounds(new Rectangle(leftOffset, 0, 250, 30));
        contents.add((IFigure)phaseLabel1);
        Label phaseLabel2 = new Label(Resources.adfLifeCycle);
        font = NodeDiagramStyleSheets.getHeaderLabelFont();
        phaseLabel2.setFont(font);
        phaseLabel2.setForegroundColor(NodeDiagramStyleSheets.HEADER_LABEL_COLOR);
        phaseLabel2.setBounds(new Rectangle(leftOffset + 320, 0, 250, 30));
        contents.add((IFigure)phaseLabel2);
        Map phaseMap = AdfLifecycle.getPhaseMap();
        LifecyclePhaseFigure lastJsfPhaseFigure = null;
        int x = leftOffset;
        int y = 40;
        for (Phase jsfPhase : phaseMap.keySet()) {
            String phaseNameLabel = this.convertToLabel(jsfPhase.getName());
            LifecyclePhaseFigure jsfPhaseFigure = new LifecyclePhaseFigure(phaseNameLabel, true);
            contents.add((IFigure)jsfPhaseFigure);
            jsfPhaseFigure.setBounds(new Rectangle(x, y, 250, 30));
            List adfPhases = (List)phaseMap.get(jsfPhase);
            for (Phase p : adfPhases) {
                String name = p.getName();
                final LifecyclePhaseFigure f = new LifecyclePhaseFigure(name);
                contents.add((IFigure)f);
                f.setBounds(new Rectangle(leftOffset + 350, y, 220, 30));
                y += 35;
                f.addMouseListener(new MouseListener(){

                    public void mouseDoubleClicked(MouseEvent me) {
                    }

                    public void mousePressed(MouseEvent me) {
                        if (AdfLifecycleDiagram.this.currentSelection != null) {
                            AdfLifecycleDiagram.this.currentSelection.setSelect(false);
                        }
                        f.setSelect(true);
                        AdfLifecycleDiagram.this.currentSelection = f;
                    }

                    public void mouseReleased(MouseEvent me) {
                    }
                });
                this.adfPhaseFigureMap.put(name, f);
                PolylineConnection conn = new PolylineConnection();
                conn.setForegroundColor(LINK_COLOR);
                conn.setSourceAnchor((ConnectionAnchor)jsfPhaseFigure.rightOutAnchor);
                conn.setTargetAnchor((ConnectionAnchor)f.leftInAnchor);
                conn.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
                conn.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
                contents.add((IFigure)conn);
            }
            if (lastJsfPhaseFigure != null) {
                PolylineConnection conn = new PolylineConnection();
                conn.setForegroundColor(LINK_COLOR);
                conn.setSourceAnchor((ConnectionAnchor)lastJsfPhaseFigure.bottomOutAnchor);
                conn.setTargetAnchor((ConnectionAnchor)jsfPhaseFigure.topInAnchor);
                conn.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
                conn.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
                contents.add((IFigure)conn);
            }
            lastJsfPhaseFigure = jsfPhaseFigure;
            x = leftOffset;
        }
        panel.add((IFigure)contents);
        panel.setPreferredSize(500, y + 100);
        this.initAdfBreakpointData();
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointsListener)this);
    }

    private void initAdfBreakpointData() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] brkpts = breakpointManager.getBreakpoints(AdfDebugModel.getModelIdentifier());
        for (LifecyclePhaseFigure fig : this.adfPhaseFigureMap.values()) {
            fig.setData(null);
        }
        IBreakpoint[] iBreakpointArray = brkpts;
        int n = brkpts.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof AdfLifecyclePhaseBreakpoint) {
                AdfLifecyclePhaseBreakpoint adfBrkpt = (AdfLifecyclePhaseBreakpoint)b;
                this.updateFigure(adfBrkpt, true);
            }
            ++n2;
        }
    }

    private void updateFigure(AdfLifecyclePhaseBreakpoint adfBrkpt, boolean add) {
        if (adfBrkpt.getMethodName().endsWith("markPhaseBoundary")) {
            String phaseName = adfBrkpt.getPhaseName();
            this.breakPointMap.put(phaseName, (IAdfLifecyclePhaseBreakpoint)adfBrkpt);
            LifecyclePhaseFigure phaseFigure = this.adfPhaseFigureMap.get(phaseName);
            if (add) {
                phaseFigure.setData((IAdfLifecyclePhaseBreakpoint)adfBrkpt);
            } else {
                phaseFigure.setData(null);
            }
        }
    }

    private String convertToLabel(String name) {
        if (name.startsWith("jsf")) {
            name = name.substring(3);
            StringBuffer sb = new StringBuffer();
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c > 'A' && c < 'Z') {
                    sb.append(' ');
                }
                sb.append(c);
                ++n2;
            }
            return sb.toString().trim();
        }
        return name;
    }

    public Figure setBreakpointHit(String phaseName, boolean isBeforePhase) {
        LifecyclePhaseFigure fig;
        if (phaseName == null) {
            return null;
        }
        if (this.currentSelection != null) {
            this.currentSelection.setSelect(false);
            this.currentSelection.setBreakpointHit(false, false);
        }
        this.currentSelection = fig = this.adfPhaseFigureMap.get(phaseName);
        fig.setBreakpointHit(true, isBeforePhase);
        return fig;
    }

    public void resetHightLight() {
        if (this.currentSelection != null) {
            this.currentSelection.setSelect(false);
            this.currentSelection.setBreakpointHit(false, false);
            this.currentSelection = null;
        }
    }

    public void zoomIn() {
        this.zoom += 10;
        this.zoomPanel.setZoom(this.getScale());
    }

    public void zoomOut() {
        if (this.zoom > 0) {
            this.zoom -= 10;
        }
        this.zoomPanel.setZoom(this.getScale());
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof AdfLifecyclePhaseBreakpoint) {
                AdfLifecyclePhaseBreakpoint adfBrkpt = (AdfLifecyclePhaseBreakpoint)b;
                this.updateFigure(adfBrkpt, true);
            }
            ++n2;
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof AdfLifecyclePhaseBreakpoint) {
                AdfLifecyclePhaseBreakpoint adfBrkpt = (AdfLifecyclePhaseBreakpoint)b;
                this.updateFigure(adfBrkpt, false);
            }
            ++n2;
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint b = iBreakpointArray[n2];
            if (b instanceof AdfLifecyclePhaseBreakpoint) {
                AdfLifecyclePhaseBreakpoint adfBrkpt = (AdfLifecyclePhaseBreakpoint)b;
                try {
                    this.updateFigure(adfBrkpt, adfBrkpt.isEnabled());
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        StructuredSelection s = new StructuredSelection(new Object[]{this.currentSelection == null ? new Object() : this.currentSelection});
        return s;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        StructuredSelection sel = (StructuredSelection)selection;
        String name = sel.getFirstElement().toString();
        LifecyclePhaseFigure f = this.adfPhaseFigureMap.get(name);
        if (f != null) {
            if (this.currentSelection != null) {
                this.currentSelection.setSelect(false);
            }
            this.currentSelection = f;
            f.setSelect(true);
        }
    }

    private static final class Resources
    extends NLS {
        public static String jsfLifeCycle;
        public static String adfLifeCycle;

        static {
            Resources.initializeMessages((String)AdfLifecycleDiagram.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

