/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.decorator;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.pagedef.BindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.DCBindingElement;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.IPageDefinitionDecorationProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DecoratedImageManager;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jface.resource.ImageDescriptor;

public class BreakpointDecorationProvider
implements IPageDefinitionDecorationProvider {
    private static DecoratedImageManager.DecorationHandle beforeBreakpointHandle;
    private static DecoratedImageManager.DecorationHandle afterBreakpointHandle;
    private static DecoratedImageManager.DecorationHandle beforeBreakpointIPHandle;
    private static DecoratedImageManager.DecorationHandle afterBreakpointIPHandle;
    private IPageDefinitionContext context = null;

    public List<DecoratedImageManager.DecorationHandle> computeDebugDecorationHandles(IObject element) {
        ArrayList<DecoratedImageManager.DecorationHandle> decorationHandles = new ArrayList<DecoratedImageManager.DecorationHandle>(5);
        if (element instanceof IBindingObject) {
            IFile file;
            BindingBreakpoint brkpt;
            boolean isBeforeIpFound = false;
            boolean isAfterIpFound = false;
            String id = element.getId();
            DCBindingElement currentBindingElm = this.getCurrentBindingElement();
            if (currentBindingElm != null && (element instanceof IBinding || element instanceof IExecutable) && id.equals(currentBindingElm.getBindingName())) {
                if (currentBindingElm.isBeforeBinding()) {
                    decorationHandles.add(this.getBeforeBreakpointIPHandle());
                    isBeforeIpFound = true;
                } else {
                    decorationHandles.add(this.getAfterBreakpointIPHandle());
                    isAfterIpFound = true;
                }
            }
            if ((brkpt = AdfDebugModel.findBidningBreakpoint((IResource)(file = this.context.getAccessibleFile((IObject)this.context.getPageDefinition())), (String)id, (boolean)true)) != null && !isBeforeIpFound) {
                try {
                    if (brkpt.isEnabled()) {
                        decorationHandles.add(this.getBeforeBreakpointHandle());
                    }
                }
                catch (Exception exception) {}
            }
            if ((brkpt = AdfDebugModel.findBidningBreakpoint((IResource)file, (String)id, (boolean)false)) != null && !isAfterIpFound) {
                try {
                    if (brkpt.isEnabled()) {
                        decorationHandles.add(this.getAfterBreakpointHandle());
                    }
                }
                catch (Exception exception) {}
            }
        }
        return decorationHandles;
    }

    private DCBindingElement getCurrentBindingElement() {
        IAdaptable object = DebugUITools.getDebugContext();
        if (object != null && object instanceof JDIStackFrame) {
            DCBindingElement obj = (DCBindingElement)AdfDebugModel.getCurrentBindingElement();
            if (obj != null) {
                return obj;
            }
            try {
                JDIStackFrame f = (JDIStackFrame)object;
                IJavaThread thread = (IJavaThread)f.getThread();
                JDIDebugTarget jdiTarget = (JDIDebugTarget)thread.getDebugTarget();
                IJavaType[] types = jdiTarget.getJavaTypes("oracle.adf.share.ADFContext");
                if (types != null && types.length > 0 && AdfDebugModel.isAdfBindingBreakpointHit((JDIStackFrame)f)) {
                    DCBindingElement e = new DCBindingElement(f);
                    AdfDebugModel.setCurrentBindingElement((Object)e);
                    return e;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected DecoratedImageManager.DecorationHandle getBeforeBreakpointHandle() {
        if (beforeBreakpointHandle == null) {
            ImageDescriptor imgDesc = DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.BREAKPOINT_BEFORE);
            beforeBreakpointHandle = new DecoratedImageManager.DecorationHandle("beforeBreakpointDecoration", imgDesc, 0);
        }
        return beforeBreakpointHandle;
    }

    protected DecoratedImageManager.DecorationHandle getAfterBreakpointHandle() {
        if (afterBreakpointHandle == null) {
            ImageDescriptor imgDesc = DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.BREAKPOINT_AFTER);
            afterBreakpointHandle = new DecoratedImageManager.DecorationHandle("afterBreakpointDecoration", imgDesc, 1);
        }
        return afterBreakpointHandle;
    }

    protected DecoratedImageManager.DecorationHandle getBeforeBreakpointIPHandle() {
        if (beforeBreakpointIPHandle == null) {
            ImageDescriptor imgDesc = DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.IP_BEFORE);
            beforeBreakpointIPHandle = new DecoratedImageManager.DecorationHandle("beforeBreakpointIPDecoration", imgDesc, 0);
        }
        return beforeBreakpointIPHandle;
    }

    protected DecoratedImageManager.DecorationHandle getAfterBreakpointIPHandle() {
        if (afterBreakpointIPHandle == null) {
            ImageDescriptor imgDesc = DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.IP_AFTER);
            afterBreakpointIPHandle = new DecoratedImageManager.DecorationHandle("afterBreakpointIPDecoration", imgDesc, 1);
        }
        return afterBreakpointIPHandle;
    }

    public void setContext(IPageDefinitionContext context) {
        this.context = context;
    }
}

