/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui;

import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.DeletedModule;

public class TaskflowActivity
implements IAdaptable {
    private JDIStackFrame stackFrame;
    private String taskflowId;
    private String activityId;
    private String documentName;
    private IFile taskflowDefinition;
    private IJavaProject javaProj = null;

    public IFile getTaskflowDefinition() {
        return this.taskflowDefinition;
    }

    public String getTaskflowId() {
        return this.taskflowId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setFrameStack(JDIStackFrame frameStack) {
        this.stackFrame = frameStack;
        this.initFieldData();
    }

    private void initFieldData() {
        if (this.stackFrame == null || this.stackFrame.isDisconnected() || !this.stackFrame.getThread().isSuspended()) {
            return;
        }
        try {
            JDIObjectValue obj;
            IJavaVariable activityBreakpointDetail = this.stackFrame.findVariable("activityBreakpointDetail");
            if (activityBreakpointDetail != null && (obj = (JDIObjectValue)activityBreakpointDetail.getValue()) != null) {
                try {
                    IJavaFieldVariable taskflowIdFld = obj.getField("taskFlowId", false);
                    IJavaFieldVariable activityIdFld = obj.getField("activityId", false);
                    IJavaFieldVariable documentNameFld = obj.getField("documentName", false);
                    if (documentNameFld != null) {
                        this.documentName = documentNameFld.getValue().getValueString();
                    }
                    if ("null".equals(this.documentName)) {
                        this.documentName = "/WEB-INF/adfc-config.xml";
                    }
                    String string = this.taskflowId = taskflowIdFld.getValue() != null ? taskflowIdFld.getValue().getValueString() : "";
                    if (this.taskflowId.equals("null")) {
                        this.taskflowId = "UNBOUNDED_TASK_FLOW";
                    }
                    this.activityId = activityIdFld.getValue().getValueString();
                    this.getAdapter(IJavaElement.class);
                }
                catch (Exception de) {
                    de.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IJavaElement.class) {
            if (this.javaProj != null) {
                return this.javaProj;
            }
            JDIDebugTarget t = this.stackFrame.getJavaDebugTarget();
            ILaunchConfiguration lcfg = t.getLaunch().getLaunchConfiguration();
            try {
                IServer server = ServerUtil.getServer((ILaunchConfiguration)lcfg);
                IModule[] modules = server.getModules();
                if (modules != null && modules.length > 0) {
                    int i = 0;
                    while (i < modules.length) {
                        IProject project;
                        if (!(modules[i] instanceof DeletedModule) && (project = modules[i].getProject()) != null) {
                            IFile file;
                            String projectType = JavaEEProjectUtilities.getJ2EEProjectType((IProject)project);
                            if ("jst.ear".equals(projectType)) {
                                IModule[] cms;
                                IModule[] iModuleArray = cms = server.getChildModules(new IModule[]{modules[i]}, (IProgressMonitor)new NullProgressMonitor());
                                int n = cms.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFile file2;
                                    IModule wm = iModuleArray[n2];
                                    project = wm.getProject();
                                    if ("jst.web".equals(JavaEEProjectUtilities.getJ2EEProjectType((IProject)project)) && (file2 = this.findTaskflowDefinitionFile(project)) != null && file2.exists()) {
                                        this.taskflowDefinition = file2;
                                        this.javaProj = JavaCore.create((IProject)project);
                                        return this.javaProj;
                                    }
                                    ++n2;
                                }
                            }
                            if ("jst.web".equals(projectType) && (file = this.findTaskflowDefinitionFile(project)) != null && file.exists()) {
                                this.taskflowDefinition = file;
                                this.javaProj = JavaCore.create((IProject)project);
                                return this.javaProj;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private IFile findTaskflowDefinitionFile(IProject project) {
        IVirtualFolder vFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            IContainer[] containers;
            IContainer[] iContainerArray = containers = vFolder.getUnderlyingFolders();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                IFile file = c.getFile((IPath)new Path(this.documentName));
                if (file.exists()) {
                    ITaskFlow taskFlow = TaskFlowFactory.createTaskFlow((IFile)file);
                    IFile taskFlowFile = TaskFlowUtil.getActivityFilePath((ITaskFlow)taskFlow, (String)this.activityId);
                    return taskFlowFile;
                }
                ++n2;
            }
        }
        return null;
    }
}

