/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui;

import java.util.ArrayList;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.pagedef.DCBindingElement;
import oracle.eclipse.tools.adf.debugger.ui.AdfLifecyclePhase;
import oracle.eclipse.tools.adf.debugger.ui.AdfLifecyclePhaseEditorInput;
import oracle.eclipse.tools.adf.debugger.ui.TaskflowActivity;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfStructureDataView;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.eclipse.tools.adf.debugger.ui.views.el.AdfELEvaluatorView;
import oracle.eclipse.tools.weblogic.ui.debugger.WeblogicSourceLookupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class AdfSourceLookupParticipant
extends WeblogicSourceLookupParticipant {
    IJavaThread suspendedThread = null;

    public Object[] findSourceElements(Object object) throws CoreException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (object instanceof JDIStackFrame) {
            JDIStackFrame f = (JDIStackFrame)object;
            String typeName = f.getDeclaringTypeName();
            IJavaThread thread = (IJavaThread)f.getThread();
            JDIDebugTarget jdiTarget = (JDIDebugTarget)thread.getDebugTarget();
            IJavaType[] types = jdiTarget.getJavaTypes("oracle.adf.share.ADFContext");
            if (types != null && types.length > 0) {
                if ("oracle.adf.controller.internal.debug.AdfLifecycleBreakpointFacadeFwk".equals(typeName)) {
                    IJavaVariable phaseNameVar = f.findVariable("phaseName");
                    if (phaseNameVar != null) {
                        this.suspendedThread = thread;
                        AdfLifecyclePhase p = new AdfLifecyclePhase();
                        p.setStackFrame(f);
                        results.add(p);
                    }
                    return results.toArray();
                }
                if ("oracle.adfinternal.controller.debug.ActivityBreakpointFacadeImpl".equals(typeName)) {
                    this.suspendedThread = thread;
                    TaskflowActivity ta = new TaskflowActivity();
                    ta.setFrameStack(f);
                    results.add(ta);
                    return results.toArray();
                }
                if (AdfDebugModel.isAdfBindingBreakpointHit((JDIStackFrame)f)) {
                    this.suspendedThread = thread;
                    DCBindingElement e = new DCBindingElement(f);
                    AdfDebugModel.setCurrentBindingElement((Object)e);
                    results.add(e);
                    return results.toArray();
                }
            }
        }
        return super.findSourceElements(object);
    }

    public IEditorInput getEditorInput(Object element) {
        DCBindingElement dcb;
        IFile pageDefFile;
        if (element instanceof AdfLifecyclePhase) {
            AdfLifecyclePhase phase = (AdfLifecyclePhase)element;
            AdfLifecyclePhaseEditorInput input = new AdfLifecyclePhaseEditorInput(phase);
            this.addDebugEventListener(input, true);
            return input;
        }
        if (element instanceof TaskflowActivity) {
            TaskflowActivity ta = (TaskflowActivity)element;
            IFile file = ta.getTaskflowDefinition();
            if (file != null) {
                FileEditorInput fin = new FileEditorInput(file);
                this.addDebugEventListener((IEditorInput)fin, true);
                return fin;
            }
        } else if (element instanceof DCBindingElement && (pageDefFile = (dcb = (DCBindingElement)element).getPageDefFile()) != null) {
            FileEditorInput fin = new FileEditorInput(pageDefFile);
            this.addDebugEventListener((IEditorInput)fin, false);
            return fin;
        }
        return null;
    }

    private void addDebugEventListener(final IEditorInput input, final boolean closeEditorAfter) {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events[0].getKind() == 1 || events[0].getKind() == 8) {
                    Object obj = events[0].getSource();
                    JDIDebugTarget target = null;
                    if (obj instanceof JDIDebugElement) {
                        target = ((JDIDebugElement)obj).getJavaDebugTarget();
                    }
                    if (AdfSourceLookupParticipant.this.suspendedThread.getDebugTarget() == target) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (closeEditorAfter) {
                                    AdfSourceLookupParticipant.this.clearAdfDebugViews(input);
                                }
                            }
                        });
                        AdfDebugModel.reset();
                        DebuggerEvaluatorUtils.resetDebuggerEvaluator();
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
            }
        });
    }

    private void clearAdfDebugViews(IEditorInput input) {
        AdfStructureDataView adfDataView;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            try {
                if (ref.getEditorInput().equals(input)) {
                    page.closeEditor(ref.getEditor(false), true);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        AdfELEvaluatorView elView = (AdfELEvaluatorView)page.findView("oracle.eclipse.tools.adf.debugger.ui.AdfElEvaluatorView");
        if (elView != null) {
            elView.disable();
        }
        if ((adfDataView = (AdfStructureDataView)page.findView("oracle.eclipse.tools.adf.debugger.ui.AdfStructureView")) != null) {
            adfDataView.clear();
        }
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof AdfLifecyclePhase) {
            return "oracle.eclipse.tools.adf.debugger.ui.AdfLifecycleDiagramEditor";
        }
        if (element instanceof TaskflowActivity) {
            return "oracle.eclipse.tools.adf.controller.ui.editor.TaskFlowEditor";
        }
        if (element instanceof DCBindingElement) {
            return "oracle.eclipse.tools.adf.view.ui.editors.PageDefinitionEditor";
        }
        return null;
    }
}

