/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui;

import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public class AdfDebugUITools {
    public static final String TASKFLOW_EDITOR_ID = "oracle.eclipse.tools.adf.controller.ui.editor.TaskFlowEditor";
    public static final String PAGEDEF_EDITOR_ID = "oracle.eclipse.tools.adf.view.ui.editors.PageDefinitionEditor";
    private static final String SYS_PROP_DEBUG = "oracle.eclipse.tools.adf.debugger.debug";

    public static void reset() {
        AdfDebugModel.reset();
        DebuggerEvaluatorUtils.resetDebuggerEvaluator();
    }

    public static void setCurrentActivity(String currentActivity) {
        AdfDebugModel.setCurrentActivity((String)currentActivity);
    }

    public static JDIStackFrame getAdfStackframe() {
        JDIStackFrame stackFrame;
        IAdaptable ctx = DebugUITools.getDebugContext();
        if (ctx != null && (stackFrame = (JDIStackFrame)ctx.getAdapter(IJavaStackFrame.class)) != null) {
            try {
                boolean enabled;
                JDIDebugTarget jdiTarget = (JDIDebugTarget)stackFrame.getDebugTarget();
                IJavaType[] types = jdiTarget.getJavaTypes("oracle.adf.share.ADFContext");
                boolean bl = enabled = types != null && types.length > 0;
                if (enabled) {
                    return stackFrame;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isDebugMode() {
        boolean result = false;
        String sysprop = System.getProperty(SYS_PROP_DEBUG);
        if (sysprop != null) {
            result = Boolean.parseBoolean(sysprop);
        }
        return result;
    }
}

